/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetAttr.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:33 $      by: $Author: gfa $


    $Log: NetAttr.h,v $
    Revision 1.1  2000/03/31 17:50:33  gfa
    Merged with /Net from several term projects


*/
#ifndef _NETATTR_H
#define _NETATTR_H

#include <NetBuf.h>

enum NetAttrKeys {
	NETATTR_WANTED_LINK,
	NETATTR_WANTED_NETWORK,
	NETATTR_WANTED_TRANSPORT,

	/* INTERFACE */
	NETATTR_IF_FROM, NETATTR_IF_TO, NETATTR_IF_MTU,

	/* ETHERNET */
	NETATTR_ETH_FROM_0, NETATTR_ETH_FROM_1, NETATTR_ETH_FROM_2,
	NETATTR_ETH_TO_0,   NETATTR_ETH_TO_1,   NETATTR_ETH_TO_2,
	NETATTR_ETH_TYPE,

	/* IP */
	NETATTR_IP_FROM_0, NETATTR_IP_FROM_1,
	NETATTR_IP_FROM_2, NETATTR_IP_FROM_3,
	NETATTR_IP_TO_0, NETATTR_IP_TO_1,
	NETATTR_IP_TO_2, NETATTR_IP_TO_3,
	NETATTR_IP_TOS, /* Type Of Service */
	NETATTR_IP_TTL, /* Time To Live */
	NETATTR_IP_DF,  /* Don't Fragment */
	NETATTR_IP_ID,  /* Fragment Identification */
	NETATTR_IP_PROTOCOL,

	/* ARP */
	NETATTR_ARP_HW_TYPE,  /* HW: hardware (normally ethernet) */
	NETATTR_ARP_HW_LEN,
	NETATTR_ARP_PR_TYPE,  /* PR: protocol (normally IP) */
	NETATTR_ARP_PR_LEN,
	NETATTR_ARP_PR_0,
	NETATTR_ARP_PR_1,

	/* UDP */
	NETATTR_UDP_FROM,
	NETATTR_UDP_TO,
	NETATTR_UDP_NOCHECKSUM,

	/* TCP */
	NETATTR_TCP_FROM,
	NETATTR_TCP_TO,

	NETATTR_LAST
};

typedef struct NetAttr_t {
	unsigned short key;  /* ==0 -> not setted */
	unsigned short data;
} NetAttr;

/* NETATTRS_* is for internal use */

#define NETATTRS_ATTRSIZE  sizeof(NetAttr)
#define NETATTRS_MAXATTRS  (63-sizeof(NetBufHdr)/NETATTRS_ATTRSIZE) /* Should exactly fill a
								       single 25x NetBuf... */
#define NETATTRS_SIZE      (NETATTRS_ATTRSIZE*NETATTRS_MAXATTRS)

typedef struct NetAttrs_t {
	NetBufHdr netbufhdr;
	
	NetAttr attr[NETATTRS_MAXATTRS];
} *NetAttrs;
		     
int netattrNew(NetAttrs *a);
int netattrHash(unsigned short key);
int netattrFind(NetAttrs a, unsigned short key);
int netattrSet(NetAttrs a, unsigned short key, unsigned short data);
void netattrUnset(NetAttrs a, unsigned short key);
int netattrGet(NetAttrs a, unsigned short key, unsigned short *data);
void netattrDebug(unsigned long family, char *title, NetAttrs a);

#define netattrFree(x) netbufFree((NetBuf)x)

#endif _NETATTR_H
