/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/NetAttr.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:33 $      by: $Author: gfa $


    $Log: NetAttr.c,v $
    Revision 1.1  2000/03/31 17:50:33  gfa
    Merged with /Net from several term projects

*/
#include <NetAttr.h>
#include <NetDebug.h>
#include <UserSupport.h>

int netattrNew(NetAttrs *a)
{
	NetAttr *at;
	int i;

	if(!netbufAlloc((NetBuf *) a, NETATTRS_SIZE)) return 0;
	
	(*a)->netbufhdr.start=NETBUF_HEADERSIZE;
	(*a)->netbufhdr.end  =NETBUF_HEADERSIZE+NETATTRS_SIZE;
	
	at = (*a)->attr;
	for(i=0; i<NETATTRS_MAXATTRS; i++) at[i].key=0;

	return 1;
}

/* This could be better :-)
 */
inline int netattrHash(unsigned short key)
{
	return key % NETATTRS_MAXATTRS;
}

inline int netattrFind(NetAttrs a, unsigned short key)
{
	int begin = netattrHash(key);
	int i=begin;
	key++;

	while(a->attr[i].key != 0) {
		if(a->attr[i].key == key) return i;
		i++;
		i%=NETATTRS_MAXATTRS;
		if(i == begin) break;
	}
	return -1;
}

int netattrSet(NetAttrs a, unsigned short key, unsigned short data)
{
	int begin = netattrHash(key);
	int i = begin;

	/* find first empty place */
	key++;
	while(a->attr[i].key != 0 && a->attr[i].key != key) {
		i++;
		i%=NETATTRS_MAXATTRS;
		if(i == begin) return 0; /* full! */
	}
	a->attr[i].key=key;
	a->attr[i].data=data;
	return 1;
}

void netattrUnset(NetAttrs a, unsigned short key)
{
	int i = netattrFind(a, key);
	if(i>=0) a->attr[i].key=0;
}

int netattrGet(NetAttrs a, unsigned short key, unsigned short *data)
{
	int i = netattrFind(a, key);
	if(i>=0) {
		*data = a->attr[i].data;
		return 1;
	}
	return 0;
}

/* take from header file and then (vi):
 * s/\([^ \t]*\),/case \1: netdbgDisplay(family,"\1 :");/
 */
static void netattrDebugAttr(unsigned long family, NetAttr a)
{
	switch(a.key-1) {
		case NETATTR_WANTED_LINK:      netdbgDisplay(family,"NETATTR_WANTED_LINK     :"); break;
		case NETATTR_WANTED_NETWORK:   netdbgDisplay(family,"NETATTR_WANTED_NETWORK  :"); break;
		case NETATTR_WANTED_TRANSPORT: netdbgDisplay(family,"NETATTR_WANTED_TRANSPORT:"); break;

		case NETATTR_IF_FROM:          netdbgDisplay(family,"NETATTR_IF_FROM         :"); break;
		case NETATTR_IF_TO:            netdbgDisplay(family,"NETATTR_IF_TO           :"); break;
		case NETATTR_IF_MTU:           netdbgDisplay(family,"NETATTR_IF_MTU          :"); break;

		case NETATTR_ETH_FROM_0:       netdbgDisplay(family,"NETATTR_ETH_FROM_0      :"); break;
		case NETATTR_ETH_FROM_1:       netdbgDisplay(family,"NETATTR_ETH_FROM_1      :"); break;
		case NETATTR_ETH_FROM_2:       netdbgDisplay(family,"NETATTR_ETH_FROM_2      :"); break;
		case NETATTR_ETH_TO_0:         netdbgDisplay(family,"NETATTR_ETH_TO_0        :"); break;
		case NETATTR_ETH_TO_1:         netdbgDisplay(family,"NETATTR_ETH_TO_1        :"); break;
		case NETATTR_ETH_TO_2:         netdbgDisplay(family,"NETATTR_ETH_TO_2        :"); break;
		case NETATTR_ETH_TYPE:         netdbgDisplay(family,"NETATTR_ETH_TYPE        :"); break;

		case NETATTR_IP_FROM_0:        netdbgDisplay(family,"NETATTR_IP_FROM_0       :"); break;
		case NETATTR_IP_FROM_1:        netdbgDisplay(family,"NETATTR_IP_FROM_1       :"); break;
		case NETATTR_IP_FROM_2:        netdbgDisplay(family,"NETATTR_IP_FROM_2       :"); break;
		case NETATTR_IP_FROM_3:        netdbgDisplay(family,"NETATTR_IP_FROM_3       :"); break;
		case NETATTR_IP_TO_0:          netdbgDisplay(family,"NETATTR_IP_TO_0         :"); break;
		case NETATTR_IP_TO_1:          netdbgDisplay(family,"NETATTR_IP_TO_1         :"); break;
		case NETATTR_IP_TO_2:          netdbgDisplay(family,"NETATTR_IP_TO_2         :"); break;
		case NETATTR_IP_TO_3:          netdbgDisplay(family,"NETATTR_IP_TO_3         :"); break;
		case NETATTR_IP_TOS:           netdbgDisplay(family,"NETATTR_IP_TOS          :"); break;
		case NETATTR_IP_TTL:           netdbgDisplay(family,"NETATTR_IP_TTL          :"); break;
		case NETATTR_IP_DF:            netdbgDisplay(family,"NETATTR_IP_DF           :"); break;
		case NETATTR_IP_ID:            netdbgDisplay(family,"NETATTR_IP_ID           :"); break;
		case NETATTR_IP_PROTOCOL:      netdbgDisplay(family,"NETATTR_IP_PROTOCOL     :"); break;

		case NETATTR_ARP_HW_TYPE:      netdbgDisplay(family,"NETATTR_ARP_HW_TYPE     :"); break;
		case NETATTR_ARP_HW_LEN:       netdbgDisplay(family,"NETATTR_ARP_HW_LEN      :"); break;
		case NETATTR_ARP_PR_TYPE:      netdbgDisplay(family,"NETATTR_ARP_PR_TYPE     :"); break;
		case NETATTR_ARP_PR_LEN:       netdbgDisplay(family,"NETATTR_ARP_PR_LEN      :"); break;
		case NETATTR_ARP_PR_0:         netdbgDisplay(family,"NETATTR_ARP_PR_0        :"); break;
		case NETATTR_ARP_PR_1:         netdbgDisplay(family,"NETATTR_ARP_PR_1        :"); break;

		case NETATTR_UDP_FROM:         netdbgDisplay(family,"NETATTR_UDP_FROM        :"); break;
		case NETATTR_UDP_TO:           netdbgDisplay(family,"NETATTR_UDP_TO          :"); break;
		case NETATTR_UDP_NOCHECKSUM:   netdbgDisplay(family,"NETATTR_UDP_NOCHECKSUM  :"); break;

		case NETATTR_LAST:             netdbgDisplay(family,"NETATTR_LAST            :"); break;
		default:                       netdbgPrintf(family,"UNKNOWN KEY (%03d)       :"
							       ,a.key-1); break;
	}

	netdbgPrintf(family," %d\n",a.data);
}

void netattrDebug(unsigned long family, char *title, NetAttrs a)
{
	int i;

	if((family==0) || (family & NETDEBUG_MASK)) {
		netdbgDisplay(family,title);
		netdbgDisplay(family," attributes:\n");
		
		for(i=0; i<NETATTRS_MAXATTRS;i++) {
			if(a->attr[i].key) netattrDebugAttr(family,a->attr[i]);
		}
	}
}

