/*
 * Copyright (c) 1988, 1992, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)in_cksum.c  8.1 (Berkeley) 6/10/93
 * $Id: NetIPchecksum.c,v 1.1 2000/03/31 17:50:37 gfa Exp $
 */

/* Modified for TOPSY by David Schweikert */

#include <NetBuf.h>
#include <NetDebug.h>

/*
 * Checksum routine for Internet Protocol family headers (Portable Version).
 *
 * This routine is very heavily used in the network
 * code and should be modified for each CPU to be as fast as possible.
 */

#define ADDCARRY(x)  (x > 65535 ? x -= 65535 : x)
#define REDUCE {l_util.l = sum; sum = l_util.s[0] + l_util.s[1]; ADDCARRY(sum);}

int netipChecksum(NetBuf buf, int len)
{
        unsigned short *w;
        int sum = 0;
        int buflen = 0;
        int byte_swapped = 0;

        union {
                char    c[2];
                unsigned short s;
        } s_util;
        union {
                unsigned short s[2];
                long    l;
        } l_util;

        for (;buf && len; buf = buf->next) {
                if (buf->start == buf->end) continue;
		
                w = (unsigned short *) NETBUF_DATA(buf);
		
                if (buflen == -1) {
                        /*
                         * The first byte of this netbuf is the continuation
                         * of a word spanning between this netbuf and the
                         * last netbuf.
                         *
                         * s_util.c[0] is already saved when scanning previous
                         * netbuf.
                         */
                        s_util.c[1] = *(char *)w;
                        sum += s_util.s;
                        w = (unsigned short *)((char *)w + 1);
                        buflen = NETBUF_LEN(buf) - 1;
                        len--;
                } else {
                        buflen = NETBUF_LEN(buf);
		}

                if (len < buflen) buflen = len;
                len -= buflen;
                /*
                 * Force to even boundary.
                 */
                if ((1 & (int) w) && (buflen > 0)) {
                        REDUCE;
                        sum <<= 8;
                        s_util.c[0] = *(unsigned char *)w;
                        w = (unsigned short *)((char *)w + 1);
                        buflen--;
                        byte_swapped = 1;
                }
                /*
                 * Unroll the loop to make overhead from
                 * branches &c small.
                 */
                while ((buflen -= 32) >= 0) {
                        sum += w[0]; sum += w[1]; sum += w[2]; sum += w[3];
                        sum += w[4]; sum += w[5]; sum += w[6]; sum += w[7];
                        sum += w[8]; sum += w[9]; sum += w[10]; sum += w[11];
                        sum += w[12]; sum += w[13]; sum += w[14]; sum += w[15];
                        w += 16;
                }
                buflen += 32;
                while ((buflen -= 8) >= 0) {
                        sum += w[0]; sum += w[1]; sum += w[2]; sum += w[3];
                        w += 4;
                }
                buflen += 8;
                if (buflen == 0 && byte_swapped == 0)
                        continue;
                REDUCE;
                while ((buflen -= 2) >= 0) {
                        sum += *w++;
                }
                if (byte_swapped) {
                        REDUCE;
                        sum <<= 8;
                        byte_swapped = 0;
                        if (buflen == -1) {
                                s_util.c[1] = *(char *)w;
                                sum += s_util.s;
                                buflen = 0;
                        } else {
                                buflen = -1;
			}
                } else if (buflen == -1) {
                        s_util.c[0] = *(char *)w;
		}
        }
        if (len) netdbgDisplay(NETDEBUG_GENERIC, "netip : cksum: out of data.\n");
        if (buflen == -1) {
                /* The last netbuf has odd # of bytes. Follow the
                   standard (the odd byte may be shifted left by 8 bits
                   or not as determined by endian-ness of the machine) */
                s_util.c[1] = 0;
                sum += s_util.s;
        }
        REDUCE;
        return (~sum & 0xffff);
}
