/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/IP/NetIP.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:36 $      by: $Author: gfa $


    $Log: NetIP.h,v $
    Revision 1.1  2000/03/31 17:50:36  gfa
    Merged with /Net from several term projects


*/
#ifndef _NETIP_H
#define _NETIP_H

#include <NetBuf.h>
#include <NetAttr.h>
#include <NetHAL.h>

typedef struct {
	u8      bitfield1;    /* bit field: version:4, hdr_len:4; */
	u8	tos;
	u16	tot_len;
	u16	id;
	u16	frag_off;
	u8	ttl;
	u8	protocol;
	u16	checksum;

	u8	saddr0;
	u8	saddr1;       /* problems with alignment of u32... */
	u8	saddr2;
	u8	saddr3;

	u8	daddr0;
	u8	daddr1;
	u8	daddr2;
	u8	daddr3;

	/* options */
} NetIPHdr;

void netipInit();

#define NETIP_PROTOCOL_ICMP 1
#define NETIP_PROTOCOL_UDP  17
#define NETIP_PROTOCOL_TCP  6

#define NETIP_FRAGOFF_MASK  0x1FFF

#define NETIP_DEFAULT_MTU 1500
#define NETIP_DEFAULT_TTL 64

/* private functions */
void netipUp(NetBuf buf, NetAttrs attrs);
void netipDown(NetBuf buf, NetAttrs attrs);
unsigned int netipRoute(NetAttrs attrs);

/* private variables */
extern unsigned short netip_last_id;

#endif
