/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/IP/NetIP.c,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:36 $      by: $Author: gfa $


    $Log: NetIP.c,v $
    Revision 1.1  2000/03/31 17:50:36  gfa
    Merged with /Net from several term projects


*/
#include "NetIP.h"
#include "NetIPchecksum.h"

#include <Topsy.h>
#include <Messages.h>
#include <Syscall.h>
#include <NetDebug.h>
#include <NetBuf.h>
#include <NetAttr.h>
#include <NetConfig.h>
#include <NetModules.h>
#include <NetBitFields.h>

unsigned short netip_last_id;

static void netipMain(ThreadArg arg);

void netipInit()
{
	ThreadId netipId;
	
	/* Start main thread */
	if (tmStart(&netipId, netipMain, (ThreadArg)0, "netip") != TM_STARTOK) {
		netdbgDisplay(NETDEBUG_GENERIC, "Start: couldn't start IP thread\n");
		return;
	}

	netip_last_id = 0; /* Should be initialized with current time... */
}

static void netipMain(ThreadArg arg)
{
	ThreadId myThreadId, parentThreadId;
	NetModMsg msg;

	tmGetInfo(SELF, &myThreadId, &parentThreadId);

	// Add to list of modules
	netmodAdd(NETMODULE_IP, myThreadId);
	
	netdbgPrintf(NETDEBUG_MODULES,
		     "IP module started (moduleId=%d, threadId=%d).\n",
		     NETMODULE_IP, myThreadId);

	while(1) {
		if(!netmodMsgRecv(&msg)) return;

		switch (msg.id) {
		case NETMOD_SENDUP:
			netipUp(msg.buf, msg.attrs);
			break;
		case NETMOD_SENDDOWN:
			netipDown(msg.buf, msg.attrs);
			break;
		default:
			netdbgPrintf(NETDEBUG_GENERIC,
				      "*** ERROR: IP: Unknown message (%d)!\n",
				     msg.id);
			break;
		}
	}
}
