/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Net/ICMP/NetICMP.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.1 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/03/31 17:50:36 $      by: $Author: gfa $


    $Log: NetICMP.h,v $
    Revision 1.1  2000/03/31 17:50:36  gfa
    Merged with /Net from several term projects


*/
#ifndef _NETICMP_H
#define _NETICMP_H

#include <NetHAL.h>


typedef struct NetICMPHdr_t {
	u8	type;
	u8	code;
	u16	checksum;

	union {
		struct {
			u16	id;
			u16	sequence;
		} echo;
		u32	gateway;
		struct {
			u16	__unused;
			u16	mtu;
		} frag;
	} data;
} *NetICMPHdr;

void neticmpInit();

#define NETICMP_TYPE_ECHOREPLY		0	/* Echo Reply			*/
#define NETICMP_TYPE_DEST_UNREACH	3	/* Destination Unreachable	*/
#define NETICMP_TYPE_SOURCE_QUENCH	4	/* Source Quench		*/
#define NETICMP_TYPE_REDIRECT		5	/* Redirect (change route)	*/
#define NETICMP_TYPE_ECHO		8	/* Echo Request			*/
#define NETICMP_TYPE_TIME_EXCEEDED	11	/* Time Exceeded		*/
#define NETICMP_TYPE_PARAMETERPROB	12	/* Parameter Problem		*/
#define NETICMP_TYPE_TIMESTAMP		13	/* Timestamp Request		*/
#define NETICMP_TYPE_TIMESTAMPREPLY	14	/* Timestamp Reply		*/
#define NETICMP_TYPE_INFO_REQUEST	15	/* Information Request		*/
#define NETICMP_TYPE_INFO_REPLY		16	/* Information Reply		*/
#define NETICMP_TYPE_ADDRESS		17	/* Address Mask Request		*/
#define NETICMP_TYPE_ADDRESSREPLY	18	/* Address Mask Reply		*/

#endif
