/*
    MemoryLayout.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
#ifndef __MEMORYLAYOUT_H__
#define __MEMORYLAYOUT_H__

/* available memory: give a total of 1 meg total. 
 * 256k for the kernel and 768k for the user
 * 
 * start.c does a malloc to get the memory where topsy runs
 * except for the kernel code and data which reside in the 
 * unix processes text and data segment all other stuff like 
 * stacks (including exception) and user code and data is located
 * in PHYSMEM.
 */
#define PHYSMEM   (1*1024*1024)
#define USERMEM   (64*12*1024)
#define USERSTART (PHYSMEM-USERMEM) 
#define KERNELMEM   (PHYSMEM-USERMEM)
#define KERNELSTART   (0)

/* PAGESIZE is the machines real page size */
#define PAGEBITS             12
#define PAGESIZE            (1 << PAGEBITS)
#define PAGEFRAMEMASK       (0xffffffff << PAGEBITS)
#define PAGEMASK            (~PAGEFRAMEMASK)
#define PAGENUMBER(addr)    (((unsigned long)addr) >> PAGEBITS)
#define PAGEREMAINDER(addr) (((unsigned long)addr) & PAGEMASK)

/* logical page size is the granularity of vm regions 
 * this may be smaller on a direct mapped memory system. 
 * if paging is used LOGICAL and PHYSICAL have to be the same size 
 */
#define LOGICALPAGEBITS             8
#define LOGICALPAGESIZE            (1 << LOGICALPAGEBITS)
#define LOGICALPAGEFRAMEMASK       (0xffffffff << LOGICALPAGEBITS)
#define LOGICALPAGEMASK            (~LOGICALPAGEFRAMEMASK)
#define LOGICALPAGENUMBER(addr)    (((unsigned long)addr) >> LOGICALPAGEBITS)
#define LOGICALPAGEREMAINDER(addr) (((unsigned long)addr) & LOGICALPAGEMASK)

/* used as a boot and later as an exception stack */
#define BOOTSTACKSIZE	PAGESIZE
#define BOOTSTACKBOTTOM	(KERNELSTART)
#define BOOTSTACKTOP	(BOOTSTACKBOTTOM+BOOTSTACKSIZE-4)

#endif
