/*
    MMMapping.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
#ifndef _MMMAPPING_H_
#define _MMMAPPING_H_

#include "Topsy.h"
#include "Memory.h"
#include "MemoryLayout.h"

/* error codes */
#define MM_INITMEMORYMAPPINGFAILED  1
#define MM_INITMEMORYMAPPINGOK      2
#define MM_MAPPAGESFAILED           3
#define MM_MAPPAGESOK               4
#define MM_UNMAPPAGESFAILED         5
#define MM_UNMAPPAGESOK             6
#define MM_MOVEPAGEFAILED           7
#define MM_MOVEPAGEOK               8
#define MM_ADDRESSSPACERANGEFAILED  9
#define MM_ADDRESSSPACERANGEOK      10
#define MM_PROTECTPAGEFAILED        11
#define MM_PROTECTPAGEOK            12


typedef enum {READ_WRITE_PAGE, READ_ONLY_PAGE, PROTECTED_PAGE, INVALID_PAGE}
    PageStatus;
typedef unsigned long int Page;


#warning ______________bootStackBottom_______

extern unsigned int bootStackBottom;
extern unsigned int physBase;


Error mmInitMemoryMapping(Address  codeAddr,
                       unsigned long int  codeSize, Address  dataAddr,
                       unsigned long int  dataSize, 
		       Address userLoadedInKernelAt);
Error mmMapPages(Page startPage, Page endPage, PageStatus pstat);
Error mmUnmapPages(Page startPage, Page nOfPages);
Error mmMovePage(Page from, Page to);
Error mmProtectPage(Page page, ProtectionMode pmode);
Error mmAddressSpaceRange(AddressSpace space, Address*  addressPtr,
                     unsigned long int*  sizePtr);

#endif
