/*
    MMError.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/

#include "MMError.h"
#include "Threads.h"
#include "Messages.h"
#include "TMHal.h"

#include "Unix.h"

static void mmBusError(ThreadId currentThread);
static void mmAddressError(ThreadId currentThread);
static void mmError(ThreadId currentThread, char* errorString);


void mmInstallErrorHandlers(void)
{
    tmSetExceptionHandler(ADDRESSERROR, mmAddressError);
    tmSetExceptionHandler(BUSERROR, mmBusError);
}


static void mmError(ThreadId currentThread, char* errorString)
{
    Message msg;
    
    msg.id = TM_KILL;
    msg.from = MMTHREADID;
    msg.msg.tmKill.id = currentThread;
    
    ERROR(errorString);
    printRegisters();

    /* immediate in-kernel delivery without syscall
     * kSend does a schedule after the message arrived
     */
    kSend(TMTHREADID, &msg); 
}

static void mmBusError(ThreadId currentThread)
{
    mmError(currentThread, "bus error");
}


static void mmAddressError(ThreadId currentThread)
{
    mmError(currentThread, "address error");
}
