/*
    tlb.S, Copyright  (c) by Eckart Zitzler,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/mips/tlb.S,v $
 	Author(s):             Eckart Zitzler
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.11 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:31 $      by: $Author: ruf $
	
	
	$Log: tlb.S,v $
	Revision 1.11  1999/12/13 21:48:31  ruf
	GNU General Public Licence Update
	
	Revision 1.10  1999/10/27 14:20:09  jeker
	fixes in mips asm code
	
	Revision 1.9  1999/10/27 04:51:08  jeker
	*** empty log message ***

	Revision 1.8  1999/10/23 19:07:13  jeker
	added Makefile.SimOS.mips and did some code cleanup

	Revision 1.7  1999/10/21 20:22:29  jeker
	first commit for the R4k support

	Revision 1.6  1997/07/14 07:31:44  gfa
	removed duplicate 'j ra'

# Revision 1.5  1997/04/23  11:48:53  gfa
# replaced 8 by appropriate constant
#
# Revision 1.4  1997/03/11  08:15:52  gfa
# fixed the TLBWI bug: added SLL r,r,8 to align index value correctly
#
# Revision 1.3  1997/03/09  20:50:04  gfa
# changed function names to lower case
#
# Revision 1.2  1997/02/13  15:44:27  conrad
# First compilation/linking of complete environment (all modules)
#
# Revision 1.1  1997/02/12  16:57:36  zitzler
# Initial revision
#
*/

#include "asm.h"
#include "cpu.h"

	.text
	.align 2

	FRAME(setR3kTLBEntry)

	mtc0	a0, c0_tlblo
	mtc0	a1, c0_tlbhi
	sll	a2, a2, TLB_IND_INX_SHIFT_R3k
	mtc0	a2, c0_tlbind
	tlbwi

	END(setR3kTLBEntry)
	
	FRAME(setR4kTLBEntry)

	.set	mips3
	
	mtc0	zero, c0_tlbpm
	mtc0	a0, c0_tlblo0
	mtc0	a1, c0_tlblo1
	mtc0	a2, c0_tlbhi
	sll	a3, a3, TLB_IND_INX_SHIFT_R4k
	mtc0	a3, c0_tlbind
	tlbwi
	
	.set	mips0
	
	END(setR4kTLBEntry)

	FRAME(setR4kTLBWired)

	.set	mips3
	
	mtc0	a0, c0_tlbwrd

	.set	mips0
	
	END(setR4kTLBWired)
	
	

