/*
    MemoryLayout.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/mips/MemoryLayout.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.5 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:31 $      by: $Author: ruf $
	
	
	$Log: MemoryLayout.h,v $
	Revision 1.5  1999/12/13 21:48:31  ruf
	GNU General Public Licence Update
	
	Revision 1.4  1999/01/06 17:47:35  cjeker
	code cleaning
	
	Revision 1.3  1997/03/14 00:01:10  gfa
	added macros for page sizes and masks
	
 * Revision 1.2  1997/03/11  08:16:58  gfa
 * *** empty log message ***
 *
 * Revision 1.1  1997/02/04  11:33:39  topsy
 * Initial revision
 *
*/
#ifndef _MEMORYLAYOUT_H_
#define _MEMORYLAYOUT_H_

#include "cpu.h"

/* available memory */
#define PHYSMEM (1*1024*1024)
#define USERMEM (64*4*1024)

/* PAGESIZE is the machines real page size */
#define PAGEBITS             12
#define PAGESIZE            (1 << PAGEBITS)
#define PAGEFRAMEMASK       (0xffffffff << PAGEBITS)
#define PAGEMASK            (~PAGEFRAMEMASK)
#define PAGENUMBER(addr)    (((unsigned long)addr) >> PAGEBITS)
#define PAGEREMAINDER(addr) (((unsigned long)addr) & PAGEMASK)

/* logical page size is the granularity of vm regions 
 * this may be smaller on a direct mapped memory system. 
 * if paging is used LOGICAL and PHYSICAL have to be the same size 
 */
#define LOGICALPAGEBITS             8
#define LOGICALPAGESIZE            (1 << LOGICALPAGEBITS)
#define LOGICALPAGEFRAMEMASK       (0xffffffff << LOGICALPAGEBITS)
#define LOGICALPAGEMASK            (~LOGICALPAGEFRAMEMASK)
#define LOGICALPAGENUMBER(addr)    (((unsigned long)addr) >> LOGICALPAGEBITS)
#define LOGICALPAGEREMAINDER(addr) (((unsigned long)addr) & LOGICALPAGEMASK)

/* used as a boot and later as an exception stack */
#define BOOTSTACKSIZE	PAGESIZE
#define BOOTSTACKBOTTOM	(K0SEG_BASE)
#define BOOTSTACKTOP	(BOOTSTACKBOTTOM+BOOTSTACKSIZE-4)

#endif