/*
    mmHalAsm.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/ia32/mmHalAsm.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:31 $      by: $Author: ruf $
	
	
	$Log: mmHalAsm.h,v $
	Revision 1.2  1999/12/13 21:48:31  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:41  jeker
	Initial revision
	
*/
#ifndef __SMMHALASM_H__
#define __SMMHALASM_H__

/* memory.S */
unsigned long __maxPhysMem();
/* functions provided for implementing VMMM */
unsigned long __memPagesAvail(unsigned short pPageOrganizerSelector);
unsigned long __memPagesUsed(unsigned short pPageOrganizerSelector);
unsigned long __getFreePage(unsigned short pPageOrganizerSelector);
void __emptyPUT(unsigned short pPageOrganizerSelector);
void __setPageUsed(unsigned short pPageOrganizerSelector, unsigned long pPage);
void __setPageUnUsed(unsigned short pPageOrganizerSelector, unsigned long pPage);

/*GDT*************************************************************************/
/* gdt.S */
void  __set_GDTEntry(unsigned short uSelector, unsigned long uBASE, unsigned long uLIMIT,
                unsigned char uACCESS_B5, unsigned char uTYPE_B6);
void  __set_GDTR(unsigned short  plimit, unsigned long  pbase);
void  __get_GDTR(unsigned short *plimit, unsigned long *pbase);
void  __set_GDTE(unsigned short pEntry, GDTEPtr pGDTE);
void  __get_GDTE(unsigned short pEntry, GDTEPtr pGDTE);

/*IDT*************************************************************************/
/* idt.S */
void  __set_IDTEntry(unsigned short pIDTSel, unsigned short uINTNo, unsigned short pCodeSel,
                     unsigned long  uOFFS,   unsigned short uINTType);
void  __get_IDTE(unsigned short pIDTSel, unsigned short pEntry, IDTEPtr pIDTE);
void  __set_IDTR(unsigned short  plimit, unsigned long  pbase);
void  __get_IDTR(unsigned short *plimit, unsigned long *pbase);
void  __reset_IDTR();

/*TSS*************************************************************************/
void __createTSS(unsigned short pAliasSel);
void __activateTSS(unsigned short pTSS_Selector); 

#endif
