/*
    MemoryLayout.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/ia32/MemoryLayout.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:31 $      by: $Author: ruf $
	
	
	$Log: MemoryLayout.h,v $
	Revision 1.2  1999/12/13 21:48:31  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:40  jeker
	Initial revision
	
*/
#ifndef __MEMORYLAYOUT_H__
#define __MEMORYLAYOUT_H__

#include "cpu.h"

/* available memory */
#define PHYSMEM (22*1024*1024)
#define USERMEM (64*4*1024)

/* PAGESIZE is the machines real page size */
#define PAGEBITS             12
#define PAGESIZE            (1 << PAGEBITS)
#define PAGEFRAMEMASK       (0xffffffff << PAGEBITS)
#define PAGEMASK            (~PAGEFRAMEMASK)
#define PAGENUMBER(addr)    (((unsigned long)addr) >> PAGEBITS)
#define PAGEREMAINDER(addr) (((unsigned long)addr) & PAGEMASK)

/* logical page size is the granularity of vm regions 
 * this may be smaller on a direct mapped memory system. 
 * if paging is used LOGICAL and PHYSICAL have to be the same size 
 */
#define LOGICALPAGEBITS             8
#define LOGICALPAGESIZE            (1 << LOGICALPAGEBITS)
#define LOGICALPAGEFRAMEMASK       (0xffffffff << LOGICALPAGEBITS)
#define LOGICALPAGEMASK            (~LOGICALPAGEFRAMEMASK)
#define LOGICALPAGENUMBER(addr)    (((unsigned long)addr) >> LOGICALPAGEBITS)
#define LOGICALPAGEREMAINDER(addr) (((unsigned long)addr) & LOGICALPAGEMASK)

/* used as a boot and later as an exception stack */
#define BOOTSTACKSIZE     2*PAGESIZE
/* BOOTSTACKBOTTOM is relativ to the KERNEL SEGMENT. */
#define BOOTSTACKBOTTOM   0x9E000-K0SEG_BASE
#define BOOTSTACKTOP      (BOOTSTACKBOTTOM+BOOTSTACKSIZE-4)


#define gcDummySel        0*8
#define gcOSCodeSel       1*8
#define gcOSDataSel       2*8
#define gcOSGlobalSel     3*8
#define gcVideoSel        4*8
#define gcGDTSel          5*8

#define gcKCSEL            gcOSCodeSel
#define gcKDSEL            gcOSDataSel

/*GDT-Entries Definition Flags************************************************/

/*
;//////
;//// Memory Descriptor Codes: All Available (Descriptor Byte 5)
;//////
;//////                    PDLSCEWA */
#define MM_B5_A   0x01 /*  00000001b       Accesssed            */
#define MM_B5_W   0x02 /*  00000010b       Read/Write           */
#define MM_B5_E   0x04 /*  00000100b       Expand Down (ESP is incremented {fuck Intel}) */
#define MM_B5_C   0x08 /*  00001000b       Code Segment         */
#define MM_B5_S   0x10 /*  00010000b       No System Segment    */
#define MM_B5_0   0x00 /*  00000000b       Ring 0               */
#define MM_B5_1   0x20 /*  00100000b       Ring 1               */
#define MM_B5_2   0x40 /*  01000000b       Ring 2               */
#define MM_B5_3   0x60 /*  01100000b       Ring 3               */
#define MM_B5_P   0x80 /*  10000000b       Present              */
/*
;//////
;//// Memory Descriptor Codes: All Available (Descriptor Byte 6)
;//////
;//////                    GD0A0000 */
#define MM_B6_A   0x10 /*  00010000b      AVL                 */
#define MM_B6_D   0x40 /*  01000000b      Code Seg: Operand Size is 32b, Data Seg: ESP (Big)                */
#define MM_B6_G   0x80 /*  10000000b      Limit in Pages (=0: in Bytes)               */

#define MM_NO_    0x00 /*  00000000b      nothing               */
/*;//////
;//// System Descriptor Codes: Only Codes for > 80386 (no compatibility to 80286)
;//////
;//////                        PDLSTYPE */
#define SS_DESC_LDT   0x02 /*  00000010b   System Descriptor LDT Segment */
#define SS_DESC_TSG   0x05 /*  00000101b   System Descriptor Task Gate*/
#define SS_DESC_TSS   0x09 /*  00001001b   System Descriptor TSS      */
#define SS_DESC_BTS   0x0B /*  00001011b   System Descriptor Busy TSS */
#define SS_DESC_CLG   0x0C /*  00001100b   System Descriptor Call Gate*/
#define SS_DESC_INT   0x0E /*  00001110b   System Descriptor Interrupt Gate */
#define SS_DESC_TRP   0x0F /*  00001111b   System Descriptor Trap      Gate */
/*
;//////
;//// Descriptor for init of GDT Entries:
;//////
*/
/*//////
;//// OS Data & Code Descriptor
;////// */
;// MM_OSD_B5    MM_B5_P or MM_B5_0 or MM_B5_S or MM_B5_W 
;// MM_OSC_B5    MM_B5_P or MM_B5_0 or MM_B5_S or MM_B5_W or MM_B5_C */
#define MM_OSD_B5    0x93 /* 10010011b */
#define MM_OSC_B5    0x9B /* 10011011b */
/*
;// ALL STACK Segments are implemented so called "expand-up" stacks 
;//     STACK GRANULARITY is BYTE */
#define MM_STACK_B5       0x93 /*   10010011b        present,DPL=00,Non-System,writeable,accessed */
#define MM_STACK_B6       0x40 /*   01000000b        BIG bit */

/*
;// ALL DATA Segments are implemented in a 32b operand mode */
;//     DATA GRANULARITY is PAGE */
#define MM_DATA_B5        0x93 /*     10010011b       ;// present,DPL=00,Non-System,writeable,accessed */
#define MM_DATA_B6        0xC0 /*     11000000b       ;// PAGE granularity, BIG bit */
#define MM_DATA_B6_BYTE   0x40 /*     01000000b       ;// BYTE granularity, BIG bit */

/* ALL CODE Segments are implemented in a 32b operand mode */
/*     CODE GRANULARITY is PAGE : non conforming */
#define MM_CODE_B5        0x9B /*     10011011b       ;// present,DPL=00,Non-System,code segment,executable/readable,accessed */
#define MM_CODE_B6        0xC0 /*     11000000b       ;// PAGE granularity, BIG bit */

/* INTERRUPT GATE */
#define TSSGATE   0x8900
#define INTGATE   0x8E00
#define TRAPGATE  0x8F00  

/* Defining Interrupt GateWay with DPL of 3, i.e. Protection Level 3 Procedures
   may call this Interrupt GateWay */
#define SYSGATE   0xEE00

#endif
