/*
    MMMapping.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/ia32/MMMapping.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:31 $      by: $Author: ruf $
	
	
	$Log: MMMapping.h,v $
	Revision 1.3  1999/12/13 21:48:31  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1999/06/06 20:55:04  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.1  1999/05/13 17:05:39  jeker
	Initial revision

*/
#ifndef _MMMAPPING_H_
#define _MMMAPPING_H_

#include "Topsy.h"
#include "Memory.h"
#include "MemoryLayout.h"

/* error codes */
#define MM_INITMEMORYMAPPINGFAILED  1
#define MM_INITMEMORYMAPPINGOK      2
#define MM_MAPPAGESFAILED           3
#define MM_MAPPAGESOK               4
#define MM_UNMAPPAGESFAILED         5
#define MM_UNMAPPAGESOK             6
#define MM_MOVEPAGEFAILED           7
#define MM_MOVEPAGEOK               8
#define MM_ADDRESSSPACERANGEFAILED  9
#define MM_ADDRESSSPACERANGEOK      10
#define MM_PROTECTPAGEFAILED        11
#define MM_PROTECTPAGEOK            12

#warning ______________bootStackBottom_______
extern unsigned int bootStackBottom;

typedef enum {READ_WRITE_PAGE, READ_ONLY_PAGE, PROTECTED_PAGE, INVALID_PAGE}
    PageStatus;
typedef unsigned long int Page;

Error mmInitMemoryMapping(Address  codeAddr,
                       unsigned long int  codeSize, Address  dataAddr,
                       unsigned long int  dataSize, 
           Address userLoadedInKernelAt);
Error mmMapPages(Page startPage, Page endPage, PageStatus pstat);
Error mmUnmapPages(Page startPage, Page nOfPages);
Error mmMovePage(Page from, Page to);
Error mmProtectPage(Page page, ProtectionMode pmode);
Error mmAddressSpaceRange(AddressSpace space, Address*  addressPtr,
                     unsigned long int*  sizePtr);

#endif

