/*
    MMHal.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/ia32/MMHal.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:31 $      by: $Author: ruf $
	
	
	$Log: MMHal.h,v $
	Revision 1.2  1999/12/13 21:48:31  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/05/13 17:05:38  jeker
	Initial revision
	
*/
#ifndef __MMHAL_H__
#define __MMHAL_H__

typedef struct GDTE_t {
    unsigned char   Byte0;  
    unsigned char   Byte1; 
    unsigned char   Byte2; 
    unsigned char   Byte3; 
    unsigned char   Byte4; 
    unsigned char   Byte5; 
    unsigned char   Byte6; 
    unsigned char   Byte7; 
  } GDTE;
typedef GDTE* GDTEPtr;  
  
typedef struct GDTR_t {
    unsigned short  limit; 
    unsigned long   base;
  } GDTR;
typedef GDTR* GDTRPtr;
  
typedef struct IDTR_t {
    unsigned short  limit; 
    unsigned long   base;
  } IDTR;
typedef IDTR* IDTRPtr;  
  
typedef struct IDTE_t {
    unsigned char   Byte0;  
    unsigned char   Byte1; 
    unsigned char   Byte2; 
    unsigned char   Byte3; 
    unsigned char   Byte4; 
    unsigned char   Byte5; 
    unsigned char   Byte6; 
    unsigned char   Byte7; 
  } IDTE;
typedef IDTE* IDTEPtr;

  
void GDTInit();
void DispGDTRState();
void Set_GDTEntry(unsigned short pSelector, unsigned long pBase, unsigned long pSize, unsigned char pAccess, unsigned char pType);
void Get_GDTE(unsigned short pSelector, GDTEPtr pGDTE);
unsigned short Get_New_GDTE();
  
void    IDTInit();
void    Set_Def_IDTEntry(unsigned char pEntry, unsigned long pOffs, 
                          unsigned short pType);
void    DispIDTRState();
void    ResetIDR(); 

void  TSSInit();

unsigned long MaxPhysMem(); 
unsigned long MaxMemAvail(); 
void MemoryInit();

#endif

