/*
    MMDirectMapping.c, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/ia32/MMDirectMapping.c,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:30 $      by: $Author: ruf $
	
	
	$Log: MMDirectMapping.c,v $
	Revision 1.3  1999/12/13 21:48:30  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1999/06/06 20:55:03  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.1  1999/05/13 17:05:35  jeker
	Initial revision

*/
#include "MMMapping.h"
#include "Threads.h"
#include "Support.h"
#include "cpu.h"

#include "Video.h"

unsigned int bootStackBottom;

Error   mmInitMemoryMapping(
          Address codeAddr, unsigned long int codeSize,
          Address dataAddr, unsigned long int dataSize,
          Address userLoadedInKernelAt) {
  /* 
  printf("Moving User Chunk\n");
  printf("CodeAddr: to = 0x%8x, from = 0x%8x, size = %i\n",
      (unsigned int)codeAddr,
      (unsigned int)userLoadedInKernelAt, 
      (unsigned int)codeSize);
  */
  byteCopy(codeAddr, userLoadedInKernelAt, codeSize);
  /*
  printf("dataAddr: to = 0x%8x, from = 0x%8x, size = %i\n",
      (unsigned int)dataAddr,
      (unsigned int)( (unsigned long)userLoadedInKernelAt +
                      (unsigned long)dataAddr - (unsigned long)codeAddr),
      (unsigned int)dataSize);
  */
  byteCopy(dataAddr, (Address)((unsigned long)userLoadedInKernelAt + 
    (unsigned long)dataAddr - (unsigned long)codeAddr), dataSize);
  return MM_INITMEMORYMAPPINGOK;
}

Error mmMapPages(Page startPage, Page nOfPages, PageStatus pstat) {
    return MM_MAPPAGESOK;
}


Error mmUnmapPages(Page startPage, Page nOfPages) {
    return MM_UNMAPPAGESOK;
}


Error mmMovePage(Page from, Page to) {
    /* direct mapped memory systems can only copy the page */
    byteCopy((Address)(to*LOGICALPAGESIZE), (Address)(from*LOGICALPAGESIZE), 
                  LOGICALPAGESIZE);
    zeroOut((Address)(from*LOGICALPAGESIZE), LOGICALPAGESIZE);
    return MM_MOVEPAGEOK;
} 


Error mmProtectPage(Page page, ProtectionMode pmode) {
    /* direct mapped memory does nothing */
    return MM_PROTECTPAGEFAILED;
}


Error  mmAddressSpaceRange(AddressSpace space, Address* addressPtr,
          unsigned long int* sizePtr) {
    if (space == KERNEL) {
      *addressPtr = (Address)K0SEG_BASE;
      *sizePtr = K0SEG_SIZE; /* 512kB */
    }
    else if (space == USER) {
      *addressPtr = (Address)KUSEG_BASE; /* zero page invalid */
      *sizePtr = USERMEM;           /* 256kB */
    }
    else return MM_ADDRESSSPACERANGEFAILED;
    return MM_ADDRESSSPACERANGEOK;
}
