/*
    Memory.h, Copyright  (c) by Eckart Zitzler,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/Memory.h,v $
 	Author(s):             Eckart Zitzler
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.13 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:30 $      by: $Author: ruf $
	
	
	$Log: Memory.h,v $
	Revision 1.13  1999/12/13 21:48:30  ruf
	GNU General Public Licence Update
	
	Revision 1.12  1997/04/07 10:22:04  gfa
	rcs test
	
 * Revision 1.11  1997/03/24  19:16:55  gfa
 * removed hmStack from mmInit
 *
 * Revision 1.10  1997/03/16  22:19:16  gfa
 * *** empty log message ***
 *
 * Revision 1.9  1997/03/11  08:15:20  gfa
 * *** empty log message ***
 *
 * Revision 1.8  1997/03/09  20:49:37  gfa
 * *** empty log message ***
 *
 * Revision 1.7  1997/03/06  16:20:50  gfa
 * *** empty log message ***
 *
 * Revision 1.6  1997/02/14  11:25:48  zitzler
 * #include "Threads.h" deleted
 *
 * Revision 1.5  1997/02/13  16:31:29  zitzler
 * cosmetics
 *
 * Revision 1.4  1997/02/13  15:43:44  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.3  1997/02/13  12:48:22  zitzler
 * type ProtectionMode changed: all items have suffix _REGION
 *
 * Revision 1.2  1997/02/12  16:25:23  zitzler
 * exported types added
 *
 * Revision 1.1  1997/02/04  11:33:28  topsy
 * Initial revision
 *
*/

#ifndef _MEMORY_H_
#define _MEMORY_H_

#include "Topsy.h"


typedef struct SegMapDescriptor_t {      /* needed in bootstrapping process */
    unsigned long int  kernelCodeSize;
    Address            kernelCodeStart;
    unsigned long int  kernelDataSize;
    Address            kernelDataStart;
    unsigned long int  userCodeSize;
    Address            userCodeStart;
    unsigned long int  userDataSize;
    Address            userDataStart;
    Address            userJumpAddress;
    Address            userLoadedInKernelAt;
} SegMapDescriptor;

typedef SegMapDescriptor*  SegMapPtr;

#define ADDRESSSPACES 2
typedef enum {KERNEL, USER}  AddressSpace;

typedef enum {READ_WRITE_REGION, READ_ONLY_REGION, PROTECTED_REGION}
    ProtectionMode;

void mmInit(SegMapPtr segMapPtr, Address* mmStackPtr, Address* tmStackPtr);
void mmMain(ThreadArg arg);

#endif
