/*
    MMVirtualMemory.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/MMVirtualMemory.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.13 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:30 $      by: $Author: ruf $
	
	
	$Log: MMVirtualMemory.h,v $
	Revision 1.13  1999/12/13 21:48:30  ruf
	GNU General Public Licence Update
	
	Revision 1.12  1997/04/23 09:19:22  gfa
	formatting
	
 * Revision 1.11  1997/04/06  18:47:35  gfa
 * source cleanup, added vmCleanup implementation
 *
 * Revision 1.10  1997/03/27  21:57:25  gfa
 * removed heapaddress from mmvminit
 *
 * Revision 1.9  1997/03/26  09:36:06  gfa
 * *** empty log message ***
 *
 * Revision 1.8  1997/03/24  19:13:56  gfa
 * changed newListStatic to simple newList (uses less memory and code)
 *
 * Revision 1.7  1997/03/16  22:17:26  gfa
 * implemented vmMove and vmProtect syscalls
 *
 * Revision 1.6  1997/03/13  23:58:17  gfa
 * added alloc/free/move
 *
 * Revision 1.5  1997/03/11  08:13:09  gfa
 * fixed vmInit
 *
 * Revision 1.4  1997/03/09  20:47:59  gfa
 * first version of init
 *
 * Revision 1.3  1997/02/17  14:25:58  zitzler
 * macro 'MM_MAXREGIONS' moved to '.c' file
 *
 * Revision 1.2  1997/02/13  16:12:41  zitzler
 * cosmetics
 *
 * Revision 1.1  1997/02/12  16:25:02  zitzler
 * Initial revision
 *
*/

#ifndef _MMVIRTUALMEMORY_H_
#define _MMVIRTUALMEMORY_H_

#include "Topsy.h"
#include "Memory.h"
#include "Threads.h"
#include "List.h"

#define MM_VMINITOK	0
#define MM_VMINITFAILED 1

#define MM_VMEXACT	2
#define MM_VMINSIDE	3


typedef enum {VM_FREED, VM_ALLOCATED}  RegionStatus;

typedef struct RegionDesc_t {
    /* RegionStatus is implicitely known from which list the region is in */
    unsigned long int  startPage;
    unsigned long int  numOfPages;
    ProtectionMode     pmode;
    ThreadId           owner;
} RegionDesc;

typedef RegionDesc* Region;

typedef struct AddressSpaceDesc_t {
    List               regionList;
    List               freeList;
    unsigned long int  startPage; 
    unsigned long int  endPage;
} AddressSpaceDesc;

typedef AddressSpaceDesc* AddressSpacePtr;

Address mmVmGetHeapAddress(Address kernelDataStart, 
			   unsigned long int kernelDataSize);
Error  mmVmInit(Address kernelCodeStart, unsigned long int kernelCodeSize,
		Address kernelDataStart, unsigned long int kernelDataSize,
		Address userCodeStart, unsigned long int userCodeSize,
		Address userDataStart, unsigned long int userDataSize,
		Address* mmStack, Address* tmStack);
Error mmVmAlloc(Address* addressPtr, unsigned long int size, ThreadId owner);
Error mmVmFree(Address address, ThreadId claimsToBeOwner);
Error mmVmMove(Address* addressPtr, ThreadId newOwner);
Error mmVmProtect(Address startAdr, unsigned long int size,
		ProtectionMode pmode, ThreadId owner);
Error mmVmCleanup(ThreadId id);
		
#endif
