/*
    MMMain.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/MMMain.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.17 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:30 $      by: $Author: ruf $
	
	
	$Log: MMMain.c,v $
	Revision 1.17  1999/12/13 21:48:30  ruf
	GNU General Public Licence Update
	
	Revision 1.16  1997/04/23 09:19:22  gfa
	formatting
	
 * Revision 1.15  1997/04/06  18:48:07  gfa
 * added vmCleanup
 *
 * Revision 1.14  1997/03/31  20:35:34  gfa
 * adapted for global name changes (syscalls)
 *
 * Revision 1.13  1997/03/19  21:42:51  conrad
 * adding of debugging comments
 *
 * Revision 1.12  1997/03/16  22:18:45  gfa
 * *** empty log message ***
 *
 * Revision 1.11  1997/03/14  17:20:50  gfa
 * *** empty log message ***
 *
 * Revision 1.10  1997/03/14  09:25:48  gfa
 * fixed expectedFrom bug (ThreadId* vs ThreadId)
 * this type-unsafety was not catched by -Wall !
 *
 * Revision 1.9  1997/03/13  23:59:19  gfa
 * wrote mmMain
 *
 * Revision 1.8  1997/03/11  20:08:10  conrad
 * Adding of an INFO message for debugging
 *
 * Revision 1.7  1997/03/11  08:14:32  gfa
 * removed hmAlloc/hmFree messages (moved to heap manager thread)
 *
 * Revision 1.6  1997/03/09  20:49:13  gfa
 * fixed message loop
 *
 * Revision 1.5  1997/02/21  08:58:32  conrad
 * Adding of ANYMSGTYPE parameter to tmMsgRecv()
 *
 * Revision 1.4  1997/02/17  13:03:28  zitzler
 * incomplete version!
 *
 * Revision 1.3  1997/02/13  16:31:10  zitzler
 * cosmetics
 *
 * Revision 1.2  1997/02/13  15:43:44  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/12  16:24:39  zitzler
 * Initial revision
 *
*/

#include "MMMain.h"
#include "Topsy.h"
#include "Messages.h"
#include "Syscall.h"
#include "Threads.h"
#include "MMHeapMemory.h"
#include "MMVirtualMemory.h"


void mmMain(ThreadArg arg)
{
    Message            msg, reply;
    Address            address;
    ThreadId	expectedFrom;

    INFO("Entering mmMain()");
    
    reply.from = MMTHREADID; /* sent always from this thread */

    while (TRUE) {
	expectedFrom = ANY;
        if (tmMsgRecv(&expectedFrom, ANYMSGTYPE, &msg, INFINITY) == 
							TM_MSGRECVFAILED)
	    PANIC("message receive error!");
	switch (msg.id) {
	case VM_ALLOC:
	    reply.id = VM_ALLOCREPLY;
	    reply.msg.vmAllocReply.errorCode = 
			mmVmAlloc(&address, msg.msg.vmAlloc.size, msg.from);
	    reply.msg.vmAllocReply.address = address;
	    tmMsgSend(msg.from, &reply);
	    break;
	case VM_FREE:
	    reply.id = VM_FREEREPLY;
	    reply.msg.vmFreeReply.errorCode = 
				    mmVmFree(msg.msg.vmFree.address, msg.from);
	    tmMsgSend(msg.from, &reply);
	    break;
        case VM_PROTECT: 
	    reply.id = VM_PROTECTREPLY;
	    reply.msg.vmProtectReply.errorCode = mmVmProtect(
						msg.msg.vmProtect.startAddress, 
						msg.msg.vmProtect.size,
						msg.msg.vmProtect.pmode, 
						msg.from);
	    tmMsgSend(msg.from, &reply);	    
	    break;
	case VM_MOVE:				/* must be a kernel thread */
	    reply.id = VM_MOVEREPLY;
	    if (THREAD_MODE(msg.from) == KERNEL) {
		address = msg.msg.vmMove.address;
		reply.msg.vmMoveReply.errorCode = mmVmMove(&address, 
						msg.msg.vmMove.newOwner);
		reply.msg.vmMoveReply.address = address;
	    }
	    else {
		reply.msg.vmMoveReply.errorCode = VM_MOVEFAILED;
	    }
	    tmMsgSend(msg.from, &reply);	    
	    break;
	case VM_CLEANUP:			/* must be a kernel thread */
	    if (THREAD_MODE(msg.from) == KERNEL) {
		mmVmCleanup(msg.msg.vmCleanup.threadId);
	    }
	    /* this kernel internal message does not reply */
	    break;
	case TM_KILLREPLY:
	    /* simply digest Message (coming from tmThread) */
	    break;
	default:
	    reply.id = UNKNOWN_SYSCALL;
	    tmMsgSend(msg.from, &reply);
	    break;
	} 
    } 
} 
