/*
    MMInit.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/MMInit.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.20 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/06/05 14:06:27 $      by: $Author: gfa $
	
	
	$Log: MMInit.c,v $
	Revision 1.20  2000/06/05 14:06:27  gfa
	*** empty log message ***
	
	Revision 1.19  1999/12/13 21:48:30  ruf
	GNU General Public Licence Update
	
	Revision 1.18  1999/10/28 21:21:56  jeker
	hack to get R3k and R4k running
	
	Revision 1.17  1999/10/27 14:20:07  jeker
	fixes in mips asm code

	Revision 1.16  1999/10/27 11:04:58  jeker
	fixes R4k R3k port

	Revision 1.15  1999/10/21 20:22:28  jeker
	first commit for the R4k support

	Revision 1.14  1997/04/23 09:18:20  gfa
	formatting

 * Revision 1.13  1997/04/13  16:22:13  gfa
 * added user-in-kernel-at address
 *
 * Revision 1.12  1997/03/27  21:57:58  gfa
 * removed heapaddress from mmvminit
 *
 * Revision 1.11  1997/03/26  09:36:27  gfa
 * solved cyclic dependency of hmInit and vmInit
 *
 * Revision 1.10  1997/03/24  20:35:17  gfa
 * using hmAlloc/hmFree directly
 *
 * Revision 1.9  1997/03/24  19:14:37  gfa
 * removed hmStack from call to mmVmInit
 *
 * Revision 1.8  1997/03/23  12:41:58  gfa
 * moved HEAPSIZE define to config
 *
 * Revision 1.7  97/03/12  09:03:24  gfa
 * *** empty log message ***
 * 
 * Revision 1.6  1997/03/11  08:13:56  gfa
 * mmInit working now...
 *
 * Revision 1.5  1997/03/09  20:50:37  gfa
 * first version
 *
 * Revision 1.4  1997/03/06  16:15:31  gfa
 * first implementation
 *
 * Revision 1.3  1997/02/13  16:17:56  zitzler
 * cosmetics
 *
 * Revision 1.2  1997/02/13  15:43:44  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/12  16:18:50  zitzler
 * Initial revision
 *
*/

#include "MMInit.h"
#include "Threads.h"

#include "MMHeapMemory.h"
#include "MMVirtualMemory.h"
#include "MMMapping.h"
#include "MMError.h"


void mmInit(SegMapPtr segMapPtr, Address* mmStackPtr, Address* tmStackPtr)
{
    Address heapAddress;

#ifdef MMDEBUG
    ioConsolePutString("mmInit: segMapPtr=");
    ioConsolePutHexInt(segMapPtr);
    ioConsolePutString("\nkernelCodeSize=");
    ioConsolePutHexInt(segMapPtr->kernelCodeSize);
    ioConsolePutString(", start=");
    ioConsolePutHexInt(segMapPtr->kernelCodeStart);
    ioConsolePutString("\nkernelDataSize=");
    ioConsolePutHexInt(segMapPtr->kernelDataSize);
    ioConsolePutString(", start=");
    ioConsolePutHexInt(segMapPtr->kernelDataStart);
    ioConsolePutString("\nuserCodeSize=");
    ioConsolePutHexInt(segMapPtr->userCodeSize);
    ioConsolePutString(", start=");
    ioConsolePutHexInt(segMapPtr->userCodeStart);
    ioConsolePutString("\nuserDataSize=");
    ioConsolePutHexInt(segMapPtr->userDataSize);
    ioConsolePutString(", start=");
    ioConsolePutHexInt(segMapPtr->userDataStart);
    ioConsolePutString("\nuserJumpAddress=");
    ioConsolePutHexInt(segMapPtr->userJumpAddress);
    ioConsolePutString("\nuserLoadedInKernelAt=");
    ioConsolePutHexInt(segMapPtr->userLoadedInKernelAt);
    ioConsolePutString("\n");
#endif

    /* memory error handlers need to be installed */ 
    mmInstallErrorHandlers();

    /* set up page mapping */
    mmInitMemoryMapping(segMapPtr->userCodeStart, segMapPtr->userCodeSize,
	    		segMapPtr->userDataStart, segMapPtr->userDataSize,
				segMapPtr->userLoadedInKernelAt);
    
    /* build dynamic kernel heap memory in one vm region (which will be
     * created later using heap memory for lists and descriptors)
     * the heap always starts after the static kernel data...
     */
    heapAddress = mmVmGetHeapAddress(segMapPtr->kernelDataStart, 
				     segMapPtr->kernelDataSize);
    if (hmInit(heapAddress) != HM_INITOK) 
    	PANIC("heap init failed");

    /* setup memory region lists. beware: vmregionlist/freelist and first
       region descriptors must use static memory
       vmInit makes regions for the following:
       KERNEL:	boot/exception stack (first page in kernel memory)
       		kernel code
		kernel data
		kernel heap (dynamic data)
		stacks for mmStackPtr, tmStackPtr
		free region (what's left in kernel space)
		USER:	user code
		user data
		free region (what's left in user space)
     */
    if (mmVmInit(segMapPtr->kernelCodeStart, segMapPtr->kernelCodeSize,
		 segMapPtr->kernelDataStart, segMapPtr->kernelDataSize,
		 segMapPtr->userCodeStart, segMapPtr->userCodeSize,
		 segMapPtr->userDataStart, segMapPtr->userDataSize,
		 mmStackPtr, tmStackPtr) != MM_VMINITOK) {
		PANIC("vm init failed");
    }
}
