/*
    MMHeapMemory.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Memory/MMHeapMemory.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.9 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:30 $      by: $Author: ruf $
	
	
	$Log: MMHeapMemory.h,v $
	Revision 1.9  1999/12/13 21:48:30  ruf
	GNU General Public Licence Update
	
	Revision 1.8  1997/03/26 09:35:17  gfa
	*** empty log message ***
	
 * Revision 1.7  1997/03/26  09:31:00  gfa
 * rewrote the heap allocator. produces 50% less overhead, is much faster,
 * fully checked/reliable and written in 3 pages source (1 less). all boils
 * down to a ridiculous 880 bytes of mips machine code :-)
 *
 * Revision 1.6  1997/03/22  14:29:43  conrad
 * locks replace msg for heap
 *
 * Revision 1.5  1997/03/13  23:58:43  gfa
 * fixed hmAlloc
 *
 * Revision 1.4  1997/03/10  13:55:39  gfa
 * changes for HeapMemory made
 *
 * Revision 1.3  1997/03/09  20:48:22  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/13  16:08:20  zitzler
 * topsy conventions (tabs, etc.)
 *
 * Revision 1.1  1997/02/12  16:19:40  zitzler
 * Initial revision
 *
*/

#ifndef _MMKERNELMEMORY_H_
#define _MMKERNELMEMORY_H_

#include "Topsy.h"
#include "Memory.h"

/* error codes */
#define HM_INITFAILED   1
#define HM_INITOK       2

#define HM_ALLOCOK	3
#define HM_ALLOCFAILED	4
#define HM_FREEOK	5
#define HM_FREEFAILED	6


Error hmInit(Address addr);
Error hmAlloc(Address* addressPtr, unsigned long int size);
Error hmFree(Address address);

#endif







