/*
    IOHal.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*

        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/unix
/IOHal.c,v $
        Author(s):             George Fankhauser
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.4 $
        Creation Date:         
        Last Date of Change:   $Date: 1999/12/14 11:07:55 $      by: $Author: je
ker $
        
        $Log: IOHal.c,v $
        Revision 1.4  1999/12/14 11:07:55  ruf
        Corrected Header File

        Revision 1.2  1999/05/13 17:05:34  jeker
        Initial revision
*/

#include "Topsy.h"
#include "IOHal.h"
#include "IODevice.h"

#include "Unix.h"

/*
 * Very simple console output routine. accesses hardware directly, used at 
 * startup and on catastrophic events/debugging.
 *
 * A simple write is used for the unix port.
 */ 
void ioConsoleInit() {
}


void ioConsolePutChar(char c)
{
    write(STDOUT_FILENO, &c, 1); 
}
