/*
    IOHal.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/mips/IOHal.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.15 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:28 $      by: $Author: ruf $
	
	
	$Log: IOHal.h,v $
	Revision 1.15  1999/12/13 21:48:28  ruf
	GNU General Public Licence Update
	
	Revision 1.14  1999/10/23 14:19:46  jeker
	first cleanup for R4k support
	
	Revision 1.13  1999/10/21 20:22:27  jeker
	first commit for the R4k support

	Revision 1.12  1999/01/06 17:47:34  cjeker
	code cleaning

	Revision 1.11  1997/04/22 12:10:36  conrad
	setting console on B
	
 * Revision 1.10  1997/04/17  14:10:43  conrad
 * console re-set to A
 *
 * Revision 1.9  1997/04/14  21:06:47  conrad
 * *** empty log message ***
 *
 * Revision 1.8  1997/04/13  16:52:28  conrad
 * console base set to B (hardware tests)
 *
 * Revision 1.7  1997/04/07  07:52:22  gfa
 * removed hw independent functions
 *
 * Revision 1.6  97/03/26  10:59:09  gfa
 * added bi-endian addressing
 * 
 * Revision 1.5  97/03/19  07:25:38  gfa
 * *** empty log message ***
 * 
 * Revision 1.4  1997/03/09  20:53:50  gfa
 * *** empty log message ***
 *
 * Revision 1.3  1997/03/04  16:10:28  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/03/04  11:15:08  gfa
 * added ioConsolePutInt to support panic file:line
 *
 * Revision 1.1  1997/02/12  15:32:54  gfa
 * Initial revision
 *
 * Revision 1.2  1997/02/11  16:00:30  gfa
 * *** empty log message ***
 *
 * Revision 1.1  1997/02/04  11:21:04  topsy
 * Initial revision
 *
*/
#ifndef _IOHAL_H_
#define _IOHAL_H_

#include "Configuration.h"

#ifndef SIMOS

#define MODE_REGISTER 0x0	/* SCN2681 register layout */
#define STATUS_REGISTER 0x4
#define COMMAND_REGISTER 0x8
#define INTERRUPT_REGISTER 0x14
#define TX_REGISTER 0x0c

#define READY_TO_SEND 0x04	/* ready to send status */

#ifdef TOPSY_BIG_ENDIAN
#define UART_A_BASE 0xbfe00003	/* kernel uncached address */
#define UART_B_BASE 0xbfe00023	/* kernel uncached address */
#else /* TOPSY_BIG_ENDIAN */
#define UART_A_BASE 0xbfe00000	/* kernel uncached address */
#define UART_B_BASE 0xbfe00020	/* kernel uncached address */
#endif /* TOPSY_BIG_ENDIAN */

#define CONSOLE_BASE UART_B_BASE
#define MAXPUTSTRINGLEN 320

#else /* SIMOS */

/* A structure describing the SimOS console registers. */
typedef struct {
    int intr_status, data;
} SimOSConsole;


/* ... and a shortcut ``pointer'' to these registers in memory. */
#define simos_console ((SimOSConsole *)0xa0e01000)

#define MAXPUTSTRINGLEN 0xffff /* this is more or less arbitrary, but 2^16
				  should be large enough ;) */

#endif /* SIMOS */

/* those two contain hardware driver code */
void ioConsoleInit();
void ioConsolePutChar(char c);

#endif
