/*
    IOHal.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/mips/IOHal.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.24 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:28 $      by: $Author: ruf $
	
	
	$Log: IOHal.c,v $
	Revision 1.24  1999/12/13 21:48:28  ruf
	GNU General Public Licence Update
	
	Revision 1.23  1999/10/23 14:19:45  jeker
	first cleanup for R4k support
	
	Revision 1.22  1999/10/21 20:22:27  jeker
	first commit for the R4k support

	Revision 1.21  1999/01/06 17:47:34  cjeker
	code cleaning

	Revision 1.20  1998/04/08 15:08:11  gfa
	*** empty log message ***
	
	Revision 1.19  1997/04/23 18:21:02  conrad
	Sending of a \r in addition to each \n

 * Revision 1.18  1997/04/21  13:34:54  gfa
 * removed extern ttyReady...
 *
 * Revision 1.17  1997/04/21  07:24:33  conrad
 * cleanup
 *
 * Revision 1.16  1997/04/18  16:28:10  conrad
 * *** empty log message ***
 *
 * Revision 1.15  1997/04/17  12:03:23  conrad
 * *** empty log message ***
 *
 * Revision 1.14  1997/04/17  11:05:07  conrad
 * use of ioDelayAtLeastCycles(), still a problem with ioConsolePutChar() ***
 *
 * Revision 1.13  1997/04/14  21:06:47  conrad
 * *** empty log message ***
 *
 * Revision 1.12  1997/04/07  13:00:34  gfa
 * *** empty log message ***
 *
 * Revision 1.11  1997/04/07  12:19:00  gfa
 * use of ioPrevents...()
 *
 * Revision 1.10  97/04/07  07:52:11  gfa
 * removed hw independent functions
 * 
 * Revision 1.9  97/03/26  10:59:09  gfa
 * added bi-endian addressing
 * 
 * Revision 1.8  97/03/22  18:06:16  gfa
 * delayed the status polling loop
 * 
 * Revision 1.7  1997/03/19  07:25:38  gfa
 * *** empty log message ***
 *
 * Revision 1.6  1997/03/09  20:53:50  gfa
 * ioConsoleInit added
 *
 * Revision 1.5  1997/03/06  08:20:17  gfa
 * *** empty log message ***
 *
 * Revision 1.4  1997/03/04  11:15:08  gfa
 * added ioConsolePutInt to support panic file:line
 *
 * Revision 1.3  1997/02/17  16:12:08  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/13  15:54:22  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.1  1997/02/12  15:32:54  gfa
 * Initial revision
 *
 * Revision 1.2  1997/02/11  15:59:44  gfa
 * removed panic routine (moved to threads module)
 *
 * Revision 1.1  1997/02/04  11:21:04  topsy
 * Initial revision
 *
*/

#include "Topsy.h"
#include "IOHal.h"
#include "IODevice.h"


/* very simple console output routine. accesses hardware directly, used at 
 * startup and on catastrophic events/debugging...
 */ 
void ioConsoleInit() {
#ifndef SIMOS
	char* command = (char*)(CONSOLE_BASE + COMMAND_REGISTER);
    char* mode = (char*)(CONSOLE_BASE + MODE_REGISTER);
    char* status = (char*)(CONSOLE_BASE + STATUS_REGISTER);
    char* interrupt = (char*)(UART_A_BASE + INTERRUPT_REGISTER);

    *command = 0xa;	/* disable rx/tx */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);
    *mode = 0x13;	/* no parity - 8 bits/char */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);
    *mode = 0x7;	/* 1 stop bit */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);
    *status = 0xbb;	/* 9600 baud */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);
    *interrupt = 0x0;	/* select external clock disable ints */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);
    *command = 0x5;	/* enable receive/transmit */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);
#else
    
    /* SimOS console is beautifully simple. */

#endif
}


void ioConsolePutChar(char c)
{
#ifndef SIMOS
	char* transmit; 
    char* status;

    transmit = (char*)(CONSOLE_BASE + TX_REGISTER);
    status = (char*)(CONSOLE_BASE + STATUS_REGISTER);

    /* Wait for UART to become ready */
    while ((*status & READY_TO_SEND) != READY_TO_SEND) {
		ioDelayAtLeastCycles( NBCYCLESFORDELAY);
    }
    *transmit = c;			/* send it finally */
    ioDelayAtLeastCycles( NBCYCLESFORDELAY);

#else /* SIMOS */

    /* Again, the joy of simulating ``hardware'' *grin* */
    simos_console->data = c;

#endif
}


