/*
    IODevTable.h, Copyright 1999 (c) by Claudio Jeker,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/mips/IODevTable.h,v $
        Author(s):             Claudio Jeker
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.10 $
        Creation Date:         1999/04/08
        Last Date of Change:   $Date: 2000/06/05 14:06:27 $      by: $Author: gfa $
        
        
        $Log: IODevTable.h,v $
        Revision 1.10  2000/06/05 14:06:27  gfa
        *** empty log message ***

        Revision 1.9  2000/04/05 12:04:57  gfa
        *** empty log message ***

        Revision 1.8  2000/04/03 17:45:29  gfa
        *** empty log message ***

        Revision 1.7  1999/12/13 21:48:28  ruf
        GNU General Public Licence Update

        Revision 1.6  1999/10/31 14:42:46  jeker
        first fixes for SimOS

        Revision 1.5  1999/10/23 14:19:45  jeker
        first cleanup for R4k support

        Revision 1.4  1999/09/13 07:56:56  gfa
        added thread id field to device struct

        Revision 1.3  1999/05/20 15:08:39  jeker
        little changes for ia32 port

        Revision 1.2  1999/05/13 17:05:32  jeker
        Initial revision

        Revision 1.1  1999/04/08 11:40:09  jeker
        added some new files, modified some others for unix port

*/

#ifndef __IODEVTABLE_H__
#define __IODEVTABLE_H__

/* include IO.h and IODevice.h to get IO_DEVCOUNT etc */
#include "IO.h"
#include "IOArch.h"
#include "IODevice.h"

/** include all driver header files */
#ifndef SIMOS /* IDT specific devices */
#include "Drivers/IDT385_IOMap.h"
#include "Drivers/SCN2681_DUART.h"
#include "Drivers/FPGA_Comm.h"
#include "Drivers/intel8254.h"
#ifdef IO_ETHERTAP /* used on Linux MipsSim and Linux user space port */
#include "Drivers/Ethertap.h"
#endif
#else /* SIMOS */ /* SIMOS specific devices */
#include "Drivers/SimOSConsole.h"
#endif /* SIMOS */
/* truly portable devices */
#include "Drivers/Loopback.h"

/* static device table with all the driver entry points
 * (similar to Unix' device switching table)
 * this could be replaced/enhanced later by a dynamic
 * driver loader mechanism
 */
static IODeviceDesc ioDeviceTable[IO_DEVCOUNT] = {
#ifndef SIMOS /* SIMOS has other devices, first the IDT devices */
    {   "ttya",                  /* device name */
        (Address)UART_A_BASE,    /* device base address */
        NULL,                    /* buffer must be allocated by driver */
        DUARTINT,                /* interrupt */
        (InterruptHandler)devSCN2681_interruptHandler, /* ttya & b interrupt handler */
        0,                       /* thread id filled in after start */
        devSCN2681_read,         /* device read function */
        devSCN2681_write,        /* device write function */
        devSCN2681_close,        /* device close function */ 
        devSCN2681_init,         /* device init function */
        NULL,                    /* private msg handler */
        FALSE,                   /* initialisation state, normally FALSE */
        NULL                     /* data extension */ 
    },
    {   "ttyb",                  /* device name */
        (Address)UART_B_BASE,    /* device base address */
        NULL,                    /* buffer must be allocated by driver */
        -1,                      /* ttyb interrupt is handled by ttya handler */
        NULL,                    /* device interrupt handler */
        0,                       /* thread id filled in after start */
        devSCN2681_read,         /* device read function */
        devSCN2681_write,        /* device write function */
        devSCN2681_close,        /* device close function */
        devSCN2681_init,         /* device init function */
        NULL,                    /* private msg handler */
        FALSE,                   /* initialisation state, normally FALSE */
        NULL                     /* data extension */
       },
    {   "fpga",                  /* device name */
        (Address)FPGA_BASE,      /* device base address */
        NULL,                    /* buffer must be allocated by driver */
        FPGA_CARDINT,            /* interrupt */
        (InterruptHandler)devFPGA_interruptHandler, /* interrupt handling routine */
        0,                       /* thread id filled in after start */
        devFPGA_read,            /* device read function */
        devFPGA_write,           /* device write function */
        devFPGA_close,           /* device close function */
        devFPGA_init,            /* device init function */
        NULL,                    /* private msg handler */
        FALSE,                   /* initialisation state, normally FALSE */
        NULL                     /* data extension */
       },
#else /* SIMOS */ /* now the SIMOS console device */
    {   "tty",                   /* device name */
        (Address)0,              /* device base address */
        NULL,                    /* buffer must be allocated by driver */
        DUARTINT,                /* interrupt */
        (InterruptHandler)simos_console_handler, /* interrupt handling routine */
        0,                       /* thread id filled in after start */
        simos_console_read,      /* device read function */
        simos_console_write,     /* device write function */
        simos_console_close,     /* device close function */
        simos_console_init,      /* device init function */
        NULL,                    /* private msg handler */
        FALSE,                   /* initialisation state, normally FALSE */
        NULL                     /* data extension */
    },
#endif /* SIMOS */ /* the loopback device can be handled under IDT & SIMOS */
    {    "loopback",             /* device name */
        (Address)0,              /* device base address */
        NULL,                    /* buffer must be allocated by driver */
        -1,                      /* interrupt */
        NULL,                    /* interrupt handling function */
        0,                       /* thread id filled in after start */
        devLoopback_read,        /* device read function */
        devLoopback_write,       /* device write function */
        devLoopback_close,       /* device close function */
        devLoopback_init,        /* device init function */
        NULL,                    /* private msg handler */
        FALSE,                   /* initialisation state, normally FALSE */
        NULL                     /* data extension */
    }
#ifdef IO_ETHERTAP /* used on Linux MipsSim and Linux user space port */
    ,
    {   "ethertap", 
        (Address)ETHERTAP_BASE, 
	NULL, 
        ETHERTAPINT,
        (InterruptHandler)ethertap_interruptHandler,            
        0,                       /* thread id filled in after start */
        ethertap_read, 
	ethertap_write, 
        ethertap_close, 
	ethertap_init, 
        ethertap_handleMsg,
        FALSE, 
	0, 
	NULL                      /* data extension */
    }
#endif
/*    ,*/ /* this is the skeleton for the timer exercise at ETH Zurich */
/*    {   "timer1",*/             /* device name */
/*        (Address)COUNTER1,*/    /* device base address */
/*        NULL,*/                 /* no buffer needed */
/*        CLOCKINT_1,*/           /* interrupt */
/*        .....,*/                /* count down timer interrupt handler */
/*        0,*/                    /* thread id filled in after start */
/*        .....,*/                /* device read function */
/*        .....,*/                /* device write function */
/*        .....,*/                /* device close function */
/*        .....,*/                /* device init function */
/*        .....,*/                /* private msg handler */
/*        FALSE,*/                /* initialisation state, normally FALSE */
/*        NULL*/                  /* data extension */
/* } */
};

#endif
