/*
    IOArch.h, Copyright 1999 (c) by Claudio Jeker,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/mips/IOArch.h,v $
        Author(s):             Claudio Jeker
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.7 $
        Creation Date:         1999/04/08
        Last Date of Change:   $Date: 2000/04/03 17:45:29 $      by: $Author: gfa $
        
        
        $Log: IOArch.h,v $
        Revision 1.7  2000/04/03 17:45:29  gfa
        *** empty log message ***

        Revision 1.6  1999/12/13 21:48:28  ruf
        GNU General Public Licence Update

        Revision 1.5  1999/10/31 14:42:45  jeker
        first fixes for SimOS

        Revision 1.4  1999/10/23 14:19:44  jeker
        first cleanup for R4k support

        Revision 1.3  1999/10/21 20:22:27  jeker
        first commit for the R4k support

        Revision 1.2  1999/05/13 17:05:32  jeker
        Initial revision

        Revision 1.1  1999/04/08 11:40:09  jeker
        added some new files, modified some others for unix port

*/

#ifndef __IOARCH_H__
#define __IOARCH_H__

#ifndef SIMOS
/* device numbers */
#define IO_SERIAL_A	0
#define IO_SERIAL_B	1
#define IO_FPGA_COMM	2
#define IO_LOOPBACK	3
#define IO_ETHERTAP     4
/* #define TIMER1			5 */
/* do not forget to increment IO_DEVCOUNT */
#define IO_DEVCOUNT	5


#define IO_CONSOLE		IO_SERIAL_B /* alias */

#else  /* SIMOS */

#define IO_SERIAL_A	0
#define IO_LOOPBACK	1

#define IO_CONSOLE 	IO_SERIAL_A /* alias, for the SIMOS console */
#define IO_FPGA_COMM	IO_LOOPBACK

#define IO_DEVCOUNT	2

#endif /* SIMOS */

#endif

