/*
    IODevTable.h, Copyright 1999 (c) by Claudio Jeker,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        
        File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/ia32/IODevTable.h,v $
        Author(s):             Claudio Jeker
        Affiliation:           ETH Zuerich, TIK
        Version:               $Revision: 1.4 $
        Creation Date:         1999/04/08
        Last Date of Change:   $Date: 1999/12/13 21:48:28 $      by: $Author: ruf $
        
        
        $Log: IODevTable.h,v $
        Revision 1.4  1999/12/13 21:48:28  ruf
        GNU General Public Licence Update

        Revision 1.3  1999/09/13 07:56:51  gfa
        added thread id field to device struct

        Revision 1.2  1999/06/06 20:54:47  jeker
        putting everything together for Topsy 2.0

        Revision 1.1  1999/05/20 15:08:38  jeker
        little changes for ia32 port

        Revision 1.2  1999/05/13 17:05:34  jeker
        Initial revision

        Revision 1.1  1999/04/08 11:40:11  jeker
        added some new files, modified some others for unix port

*/

#ifndef __IODEVTABLE_H__
#define __IODEVTABLE_H__

/* include IO.h and IODevice.h to get IO_DEVCOUNT etc */
#include "IO.h"
#include "IODevice.h"

/* include all driver header files */
#include "Drivers/Loopback.h"
#include "Drivers/ia32/TTY.h"


/* static device table with all the driver entry points
 * (similar to Unix' device switching table)
 * this could be replaced/enhanced later by a dynamic
 * driver loader mechanism
 */
static IODeviceDesc ioDeviceTable[IO_DEVCOUNT] = {
        { "ttya", 
            (Address)0, /* Screen IO: No Direct Memory Access allowed */
            NULL,       /* buffer must be allocated by driver */
            T_IR_01,    /* Keyboard Handler */
            (InterruptHandler)TTY_Interrupt,
	    0, /* thread id filled in after start */
            TTY_read,
            TTY_write,
            TTY_close,
            TTY_init,
            NULL        /* private msg handler */,
            FALSE, NULL /* data extension */ },

        { "loopback", (Address)0, NULL, 
            -1, NULL, 
	    0, /* thread id filled in after start */
            devLoopback_read, devLoopback_write, 
            devLoopback_close, devLoopback_init, 
            NULL /* private msg handler */,
            FALSE, NULL /* data extension */ }
};

#endif
