/*
    IODevice.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/IODevice.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.14 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/04/05 12:04:57 $      by: $Author: gfa $
	
	
	$Log: IODevice.h,v $
	Revision 1.14  2000/04/05 12:04:57  gfa
	*** empty log message ***
	
	Revision 1.13  2000/01/23 17:52:05  gfa
	support async IO by returning IO_LATER from read/write, return messages
	later from interrupt.
	
	Revision 1.12  1999/12/13 21:48:25  ruf
	GNU General Public Licence Update
	
	Revision 1.11  1999/09/13 07:56:46  gfa
	added thread id field to device struct
	
	Revision 1.10  1997/04/17 11:01:07  conrad
	adding of ioDelayAtLeastCycles() function

 * Revision 1.9  1997/04/14  21:05:38  conrad
 * *** empty log message ***
 *
 * Revision 1.8  1997/04/07  13:26:25  gfa
 * adapted framework
 *
 * Revision 1.7  97/04/07  07:50:29  gfa
 * added driver dummy function (used for consecutive writes to the same
 * address in optimized code)
 * 
 * Revision 1.6  97/03/16  22:15:15  gfa
 * *** empty log message ***
 * 
 * Revision 1.5  1997/02/24  07:39:32  gfa
 * *** empty log message ***
 *
 * Revision 1.4  1997/02/17  16:51:34  gfa
 * first implementation
 *
 * Revision 1.3  1997/02/13  15:46:18  conrad
 * First compilation/linking of complete environment (all modules)
 *
 * Revision 1.2  1997/02/12  15:29:16  gfa
 * full interface defined, msg handler framework
 *
 * Revision 1.1  1997/02/04  11:20:45  topsy
 * Initial revision
 *
*/
#ifndef _IODEVICE_H_
#define _IODEVICE_H_

#include "Topsy.h"
#include "Threads.h"

/* driver messages */
#define IO_DRIVERCLOSE -1

/* return value from read/write functions to prevent a msg being sent */
#define IO_LATER -1

/* Forward declaration of IODevice
 */
typedef struct IODeviceDesc_t * IODevice;

typedef Error(*ReadFunction)(IODevice this, ThreadId, char*, long int*);
typedef Error(*WriteFunction)(IODevice this, ThreadId, char*, long int*);
typedef Error(*CloseFunction)(IODevice this);
typedef Error(*InitFunction)(IODevice this);
typedef void(*MessageHandler)(IODevice this, Message*);

typedef struct IODeviceDesc_t {
	char* name;
	Address base;
	char* buffer;
	InterruptId interrupt;
	InterruptHandler interruptHandler;
	ThreadId threadId;
	ReadFunction read;
	WriteFunction write;
	CloseFunction close;
	InitFunction init;
	MessageHandler handleMsg;
        Boolean isInitialised;
	void* extension;
} IODeviceDesc;


typedef struct DriverMessage_t {
    ThreadId from;		   /* Sender of the message */
    MessageId id;		   /* Type of the message */
	ThreadId clientThreadId;
	long int empty[2];
} DriverMessage;

void ioDeviceMain(IODevice this);

int ioDelayAtLeastCycles( int nbLoops);

#endif
