/*
    IOConsole.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/IOConsole.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:25 $      by: $Author: ruf $
	
	
	$Log: IOConsole.c,v $
	Revision 1.3  1999/12/13 21:48:25  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1999/01/06 17:47:34  cjeker
	code cleaning
	
	Revision 1.1  1997/04/09 07:44:44  conrad
	Initial revision
	
 * Revision 1.1  1997/04/07  07:52:34  gfa
 * Initial revision
 *
*/

#include "Topsy.h"
#include "IOConsole.h"
#include "IOHal.h"

static const char nullString[] = "(null pointer)";
static const char ioHexArray[16] =  {'0','1','2','3','4','5','6','7',
                                     '8','9','a','b','c','d','e','f'};


void ioConsolePutString(const char* s) {
	int i = 0;

	if (s == NULL) s = nullString;
	while ((s[i] != '\0') && (i < MAXPUTSTRINGLEN)) {
   /* Translate newlines into carriage returns plus newlines for
    * correct terminal output
    */
   	if (s[i] == '\n') {
			ioConsolePutChar('\r');
   	}
		ioConsolePutChar(s[i++]);
	}
}

void ioConsolePutHexInt(int x) {
	unsigned int i;
	for (i = 0; i < sizeof(int) * 2; i++) {
		ioConsolePutChar(ioHexArray[(x >> 28) & 0xf]);
		x = x << 4;
	}
}

void ioConsolePutInt(int x) {
	int divisor = 1;
	Boolean positive = TRUE;
	int y = x;
	
	if (x < 0) { x = -x; y = -y; positive = FALSE; }
	while (y >= 10) { y = y / 10; divisor = divisor * 10; }
	if (!positive) { ioConsolePutChar('-'); }
	y = x;
	while (divisor > 0) {
		ioConsolePutChar(ioHexArray[x/divisor]);
		x = x - (x/divisor)*divisor;
		divisor = divisor / 10;
	}
}
