/*
    video.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/ia32/video.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:27 $      by: $Author: ruf $
	
	
	$Log: video.h,v $
	Revision 1.2  1999/12/13 21:48:27  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/06/06 20:58:36  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.1  1999/05/13 17:05:31  jeker
	Initial revision

*/
#ifndef __SVIDEO_H__
#define __SVIDEO_H__

/* video.S */
void  __printchar(unsigned long XYOffs, unsigned char uTextAttr, unsigned char uc); 
void  __printstr (unsigned long XYOffs, unsigned char uTextAttr, unsigned char *uc);
void  __scrollup (unsigned char pTextAttr);
void  __scrollWindowUp(unsigned long pTopLeft, unsigned char pVCounter,
                unsigned char pHCounter, unsigned char pTextAttr);
void  __clearLine(unsigned long pLeft, unsigned long pWordCount, unsigned char pAttr);
void  __moveVideoLine(unsigned long pDest, unsigned long pSource, unsigned long pWortCount);
void  __getWindowLine(char *pBuff, unsigned long pLeftTop, unsigned long pWordCount);
void  __setWindowLine(char *pBuff, unsigned long pLeftTop, unsigned long pWordCount);
void  __setCursor(unsigned long pPosition);

#endif




