/*
    keyboard.S, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/ia32/keyboard.S,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:27 $      by: $Author: ruf $
	
	
	$Log: keyboard.S,v $
	Revision 1.2  1999/12/13 21:48:27  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/06/06 20:58:34  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.1  1999/05/13 17:05:30  jeker
	Initial revision

*/
.section .sasm
.align  4,0x9090

#include "asm.h"        /* Assembler Macro Definitions :-)      */
                        /* Located in Topsy/i386/               */
                        
#define KEYTABLEADDRGET(_name_,_tblname_) \
        FRAME (_name_) ; \
        ENTER ; \
        lea     (_tblname_),%eax ; \
        LEAVE   
        
KEYTABLEADDRGET(__addrHWKeyTrl,HWKeyTrlTbl)
KEYTABLEADDRGET(__addrKeyAscTrl,KeyCodeKeyTrlTbl)
KEYTABLEADDRGET(__addrKeyMsgTrl,KeyCodeKeyMsgTbl)

