/*
    Video.h, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/ia32/Video.h,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 2000/06/05 15:05:36 $      by: $Author: ruf $
	
	
	$Log: Video.h,v $
	Revision 1.3  2000/06/05 15:05:36  ruf
	*** empty log message ***
	
	Revision 1.2  1999/12/13 21:48:27  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/06/06 20:58:33  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.1  1999/05/13 17:05:30  jeker
	Initial revision

*/
#ifndef _Video_h_
#define _Video_h_

#include <stdarg.h>
#include "TMHal.h"

typedef struct Video_t {
    char    TextAttr;
    char    X;      
    char    Y;
  } VideoT;
typedef VideoT* VideoPtr;
  
typedef struct Window_t {
    char    X1,Y1;      
    char    X2,Y2;
  } WindowT;
typedef WindowT* WindowPtr;

void VideoInit(); 

void Printstr(long pY, long pX, char pTextAttr, char *ps);
/* LR 000604 -- Support.c defines vsprintf... */
void k_vsprintf(char *pBuffer, char *pfmt, va_list pap);
void kprintc(char pc);
void kprintf(char *ps);
void sprintf(char *pbuff, char *fmt, ... );
void printf(char *fmt, ...);
void Debug(char *ps, ...);
void DebugDisp(char *ps);
void DisplayContext(char *ps, ProcContextPtr ctx); 
void MemoryDump(char *ps, unsigned int Addr);

void ClearScreen();

unsigned char TextAttr(unsigned char pNewAttr);
unsigned char GetTextAttr();
void GotoYX(char pY, char pX);
void WhereYX(char *pY, char *pX);
void WindowState(char *pY1, char *pX1, char *pY2, char *pX2, char *pAttr); 
void Window(char pY1, char pX1, char pY2, char pX2); 
void SaveScreen(char *pBuff, char pY1, char pX1, char pY2, char pX2);
void RestoreScreen(char *pBuff, char pY1, char pX1, char pY2, char pX2);


#endif  

