/*
    TTY.c, Copyright  (c) by Lukas Ruf, lr@lpr.ch,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/ia32/TTY.c,v $
 	Author(s):             Lukas Ruf, lr@lpr.ch
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.2 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:27 $      by: $Author: ruf $
	
	
	$Log: TTY.c,v $
	Revision 1.2  1999/12/13 21:48:27  ruf
	GNU General Public Licence Update
	
	Revision 1.1  1999/06/06 20:58:29  jeker
	putting everything together for Topsy 2.0
	
	Revision 1.1  1999/05/13 17:05:29  jeker
	Initial revision

*/

#include "Messages.h"
#include "IODevice.h"
#include "Keyboard.h"
#include "Video.h"

void TTY_Interrupt(IODevice this) {
  _KeyboardISR();
}

Error TTY_init(IODevice this) {
  if (!this->isInitialised) KeyboardInit();
  this->isInitialised = TRUE;
  return IO_INITOK;
}


Error TTY_read(IODevice this, ThreadId threadId, char* buffer, 
                  long int* size) {
  int i = 0; char pc;
  while ((i < *size) && _GetChar(&pc)) 
    if (pc) 
      buffer[i++] = pc; /* ommit reading zero bytes :-) */
  *size = i;
  return IO_READOK;
}


Error TTY_write(IODevice this, ThreadId threadId, char* buffer, long int* size){
  int i = 0;
  while (i < *size) 
    kprintc(buffer[i++]);
  *size = i;
  return IO_WRITEOK;
}


Error TTY_close(IODevice this) {
    /* this message is forwarded from ioThread */
    
    /* release buffers if any */
    
    return IO_CLOSEOK;
}

