/*
    UnixConsole.c, Copyright 1999 (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*

	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/UnixConsole.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:26 $      by: $Author: ruf $
	
	$Log: UnixConsole.c,v $
	Revision 1.3  1999/12/13 21:48:26  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1999/05/13 17:05:26  jeker
	Initial revision
	
*/

#include "Messages.h"
#include "IODevice.h"
#include "Drivers/UnixConsole.h"

#include "Unix.h"

Error devUnixConsole_init(IODevice this) 
{
    return IO_INITOK;
}

#include <sys/uio.h>

Error devUnixConsole_read(IODevice this, ThreadId threadId, char* buffer, long int* size) 
{
    *size = read(STDIN_FILENO, buffer, *size);	
    if (*size == -1) return IO_READFAILED;
    else return IO_READOK;
}


Error devUnixConsole_write(IODevice this, ThreadId threadId, char* buffer, long int* size) 
{
    *size = write(STDOUT_FILENO, buffer, *size);
    if (*size == -1) return IO_WRITEFAILED;
    else return IO_WRITEOK;
}


Error devUnixConsole_close(IODevice this) 
{
    /* this message is forwarded from ioThread */
    
    /* release buffers if any */
    
    return IO_CLOSEOK;
}
