/*
    SimOSConsole.h, Copyright  (c) by 
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
*/

#include "Topsy.h"
#include "MMHeapMemory.h"
#include "IODevice.h"
#include "Configuration.h"

/* Console interrupt control bits. */
#define CONS_INT_TX 1
#define CONS_INT_RX 2

/* A structure describing the SimOS console registers. */
typedef struct {
    int intr_status, data;
} SimOSConsole;

/* ... and a shortcut ``pointer'' to these registers in memory. */
#define simos_console ((volatile SimOSConsole *)0xa0e01000)

void simos_console_handler(IODevice this);
Error simos_console_init(IODevice this);
Error simos_console_read(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error simos_console_write(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error simos_console_close(IODevice this);
