/*
    SCN2681_DUART.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/SCN2681_DUART.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.12 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:26 $      by: $Author: ruf $
	
	
	$Log: SCN2681_DUART.h,v $
	Revision 1.12  1999/12/13 21:48:26  ruf
	GNU General Public Licence Update
	
	Revision 1.11  1999/10/23 14:19:43  jeker
	first cleanup for R4k support
	
	Revision 1.10  1999/10/21 20:22:24  jeker
	first commit for the R4k support

	Revision 1.9  1999/01/06 17:47:34  cjeker
	code cleaning

	Revision 1.8  1997/04/14 21:08:16  conrad
	*** empty log message ***
	
 * Revision 1.7  1997/04/07  13:26:00  gfa
 * new version using driver framework
 *
 * Revision 1.6  1997/03/26  10:58:29  gfa
 * added bi-endian switch
 *
 * Revision 1.5  1997/03/23  12:45:53  gfa
 * first crude polling version for simulator, needs to be changed to
 * shared interrupt mode...
 *
 * Revision 1.4  1997/03/19  07:26:05  gfa
 * first hack using ioCOnsole...
 *
 * Revision 1.3  1997/02/24  07:40:03  gfa
 * *** empty log message ***
 *
 * Revision 1.2  1997/02/23  16:15:19  gfa
 * *** empty log message ***
 *
 * driver code for the philips SCN2681 dual universal asynchronous
 * receiver and transmitter (short: serial device chip :-)
*/
#ifndef _SCN2681_DUART_H_
#define _SCN2681_DUART_H_

#include "Topsy.h"
#include "MMHeapMemory.h"
#include "IODevice.h"
#include "Configuration.h"


#define MODE_REGISTER    0x0	/* SCN2681 register layout */
#define STATUS_REGISTER 0x4
#define COMMAND_REGISTER 0x8
#define TX_REGISTER 0x0c
#define RX_REGISTER TX_REGISTER
#define INTERRUPT_REGISTER 0x14

#define READY_TO_SEND 0x04	/* ready to send status */
#define RECV_MASK 0x01		/* a byte has arrived */ 

#define SCN2681_BUFSIZE 128

#define UART_REGISTER_SET_SIZE 0x20   /* size for one channel */

typedef struct devSCN2681Desc_t {
    unsigned long in, out;
    IODevice otherChannel;
} devSCN2681Desc;

typedef devSCN2681Desc* devSCN2681;

void devSCN2681_interruptHandler(IODevice this);
Error devSCN2681_init(IODevice this);
Error devSCN2681_read(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error devSCN2681_write(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error devSCN2681_close(IODevice this);

#endif

