/*
    Loopback.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/Loopback.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:26 $      by: $Author: ruf $
	
	
	$Log: Loopback.h,v $
	Revision 1.3  1999/12/13 21:48:26  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1999/01/06 17:47:34  cjeker
	code cleaning
	
	Revision 1.1  1997/05/30 18:03:30  gfa
	Initial revision
	
*/
#ifndef _LOOPBACK_H_
#define _LOOPBACK_H_

#include "Topsy.h"
#include "MMHeapMemory.h"
#include "IODevice.h"
#include "Configuration.h"

#define LOOPBACK_BUFSIZE 512

typedef struct devLoopbackDesc_t {
    unsigned long in, out, count;
} devLoopbackDesc;

typedef devLoopbackDesc* devLoopback;


Error devLoopback_init(IODevice this);
Error devLoopback_read(IODevice this, ThreadId threadId, char* buffer, 
							long int* size);
Error devLoopback_write(IODevice this, ThreadId threadId, char* buffer, 
							long int* size);
Error devLoopback_close(IODevice this);

#endif