/*
    Loopback.c, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/Loopback.c,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.3 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:26 $      by: $Author: ruf $
	
	
	$Log: Loopback.c,v $
	Revision 1.3  1999/12/13 21:48:26  ruf
	GNU General Public Licence Update
	
	Revision 1.2  1999/01/06 17:47:34  cjeker
	code cleaning
	
	Revision 1.1  1997/05/30 18:03:30  gfa
	Initial revision
	
*/

#include "Drivers/Loopback.h"
#include "Messages.h"

Error devLoopback_init(IODevice this) 
{
    devLoopback loopback;
    
    /* buffers init - be careful to check for existing buffers */
    if (!this->isInitialised) {
	hmAlloc((Address*)&(this->buffer), LOOPBACK_BUFSIZE);
	hmAlloc(&(this->extension), sizeof(devLoopbackDesc));
	loopback = (devLoopback)this->extension;

	this->isInitialised = TRUE;
    }
    else {
	loopback = (devLoopback)this->extension;
    }
    loopback->in = 0;
    loopback->out = 0;
    loopback->count = 0;

    return IO_INITOK;
}

Error devLoopback_read(IODevice this, ThreadId threadId, char* buffer, 
								long int* size) 
{
    long int i;
    devLoopback lb;
    lb = (devLoopback)this->extension;

    for (i = 0; i < *size; i++) {

    	if (lb->count == 0) break;

	buffer[i] = this->buffer[lb->out];
	lb->out = (lb->out + 1) % LOOPBACK_BUFSIZE;
	lb->count--;
    }
    *size = i;    
    return IO_READOK;
}															
															
Error devLoopback_write(IODevice this, ThreadId threadId, char* buffer, 
								long int* size)
{
    long int i;
    devLoopback lb;
    lb = (devLoopback)this->extension;

    for (i = 0; i < *size; i++) {
	
	if (lb->count == LOOPBACK_BUFSIZE) break;
	
	this->buffer[lb->in] = buffer[i];
	lb->in = (lb->in + 1) % LOOPBACK_BUFSIZE;
	lb->count++;
    }    
    *size = i;
    return IO_WRITEOK;
}

Error devLoopback_close(IODevice this)
{
  /* this message is forwarded from ioThread */
  /* release buffers if any */
    

  if (this->isInitialised) {

    hmFree((Address)this->buffer);      /* Deallocate buffer space */
    hmFree((Address)this->extension);   /* Deallocate descriptor space */

    this->isInitialised = FALSE;        /* Set Initialized flag */
  }

  return IO_CLOSEOK;
}
