/*
    IDT385_IOMap.h, Copyright  (c) by George Fankhauser,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
	
	File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/IDT385_IOMap.h,v $
 	Author(s):             George Fankhauser
 	Affiliation:           ETH Zuerich, TIK
 	Version:               $Revision: 1.11 $
 	Creation Date:         
 	Last Date of Change:   $Date: 1999/12/13 21:48:25 $      by: $Author: ruf $
	
	
	$Log: IDT385_IOMap.h,v $
	Revision 1.11  1999/12/13 21:48:25  ruf
	GNU General Public Licence Update
	
	Revision 1.10  1999/10/23 14:19:42  jeker
	first cleanup for R4k support
	
	Revision 1.9  1999/10/21 20:22:23  jeker
	first commit for the R4k support

	Revision 1.8  1999/01/06 17:47:34  cjeker
	code cleaning

	Revision 1.7  1997/05/16 14:39:38  stauffer
	fpga map corrected
	
 * Revision 1.4  1997/04/28  18:10:01  gfa
 * removed obsolete CONSOLE definition
 *
 * Revision 1.3  1997/04/07  13:25:44  gfa
 * uart defs
 *
 * Revision 1.2  1997/04/07  10:44:59  gfa
 * *** empty log message ***
 *
 * Revision 1.1  1997/04/07  10:44:13  gfa
 * Initial revision
 *
*/
#ifndef _IDT385_IOMAP_H_
#define _IDT385_IOMAP_H_

#include "Configuration.h"

#ifdef TOPSY_BIG_ENDIAN

#define UART_A_BASE 0xbfe00003	/* kernel uncached address */
#define UART_B_BASE 0xbfe00023	/* kernel uncached address */
#define FPGA_BASE   0xbfa40003	/* kernel uncached address */

#else /* TOPSY_BIG_ENDIAN */

#define UART_A_BASE 0xbfe00000	/* kernel uncached address */
#define UART_B_BASE 0xbfe00020	/* kernel uncached address */
#define FPGA_BASE   0xbfa40000	/* kernel uncached address */

#endif /* TOPSY_BIG_ENDIAN */

#endif
