/*
    FPGA_Comm.h, Copyright 1997 (c) by Bernard Stauffer,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*

  File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/FPGA_Comm.h,v $
  Author(s):             Bernard Stauffer
  Affiliation:           ETH Zuerich, TIK
  Version:               $Revision: 1.6 $
  Creation Date:         1997/05/02 20:34:00
  Last Date of Change:   $Date: 1999/12/13 21:48:25 $      by: $Author: ruf $
*/
#ifndef _FPGA_COMM_H_
#define _FPGA_COMM_H_
  
  
#include "Topsy.h"
#include "MMHeapMemory.h"
#include "IODevice.h"
#include "IDT385_IOMap.h"
#include "Configuration.h"


/*----------------------------------------------------------------*/        

#define FPGA_DATAPUT    FPGA_BASE + 0x0   /* FPGA board register layout */
#define FPGA_STATUSPUT  FPGA_BASE + 0x4
#define FPGA_DATAGET    FPGA_BASE + 0x8
#define FPGA_STATUSGET  FPGA_BASE + 0x0c

#define FPGA_BUFSIZE 1024                 /* Size of receiving buffer */


typedef struct devFPGADesc_t {
  unsigned long in, out;
} devFPGADesc;


typedef devFPGADesc* devFPGA;


void devFPGA_interruptHandler(IODevice this);
Error devFPGA_init(IODevice this);
Error devFPGA_read(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error devFPGA_write(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error devFPGA_close(IODevice this);

#endif

