/*
    Copyright 2000 (c) by David Schweikert,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public 
    Licence. A full copy of the GNU GPL is provided in the file COPYING 
    found in the development root of Topsy.
*/
/*
	
    File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/IO/Drivers/Ethertap.h,v $
    Author(s):             
    Affiliation:           ETH Zuerich, TIK
    Version:               $Revision: 1.2 $
    Creation Date:         
    Last Date of Change:   $Date: 2000/04/05 12:04:57 $      by: $Author: gfa $


    $Log: Ethertap.h,v $
    Revision 1.2  2000/04/05 12:04:57  gfa
    *** empty log message ***

    Revision 1.1  2000/03/31 17:50:32  gfa
    Merged with /Net from several term projects


*/

#ifndef _ETHERTAP_H
#define _ETHERTAP_H

#include "Topsy.h"
#include "MMHeapMemory.h"
#include "IODevice.h"
#include "Configuration.h"

#define ETHERTAP_BASE              0xbff00000
#define ETHERTAP_STATUS_REGISTER   0x000
#define ETHERTAP_CONTROL_REGISTER  0x004
#define ETHERTAP_HW_ADDRESS        0x010
#define ETHERTAP_RX_SIZE           0x020
#define ETHERTAP_RX_DATA           0x024
#define ETHERTAP_RX_END            0x7FF
#define ETHERTAP_TX_SIZE           0x800
#define ETHERTAP_TX_DATA           0x804
#define ETHERTAP_TX_END            0xFFF
	
#define ETHERTAP_SEND_MASK         0x01 // Control register
#define ETHERTAP_READ_MASK         0x02 
#define ETHERTAP_RECV_MASK         0x01 // Status register

#define ETHERTAP_FLAG_FRAGMENT     0x01

typedef struct EthertapDesc_t {
    ThreadId subscribed;
    int fragment;
    unsigned long flags; 
} EthertapDesc;

typedef EthertapDesc* Ethertap;

void  ethertap_interruptHandler(IODevice this);
Error ethertap_init(IODevice this);
Error ethertap_read(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error ethertap_write(IODevice this, ThreadId threadId, char* buffer, long int* size);
Error ethertap_close(IODevice this);
void  ethertap_handleMsg(IODevice this, Message *msg);

#endif
