/*
    TextRead.hpp, Copyright (c) 1997-1998 by Lukas Ruf,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        This copyright notice supercedes all originally or previously used 
        copyrights being used within the source code.
        
        Author: Lukas Ruf <lr@lpr.ch>
*/

// ************************************************************************** //
// Copyrights (c) 1998 Lukas Ruf                                              //
// ************************************************************************** //

#ifndef _TEXTREAD_HPP_
#define _TEXTREAD_HPP_

#include <stdio.h>

class TextReadC {
public:
  TextReadC(char *pfile);
  ~TextReadC();
  unsigned char GetNextChar();
  unsigned char *GetNextLine();
  bool EoF();
protected:
  FILE  *cFile;
  unsigned char *cBuff, *cLine;
  unsigned int  cBuffSize;
  unsigned int  cBuffPos;
  bool  cEoF;
};

#endif



