/*
    TextRead.cpp, Copyright 1997-1998 (c) by Lukas Ruf,
    Swiss Federal Institute of Technology,
    Computer Engineering and Networks Laboratory.

    TOPSY -- A Teachable Operating System.
             Implementation of a tiny and simple
             micro kernel for teaching purposes.

    For further information, please visit http://www.tik.ee.ethz.ch/~topsy

    This software is provided under the terms of the GNU General Public Licence.

    A full copy of the GNU GPL is provided in the file COPYING found in the 
    development root of Topsy.
*/
/*
        This copyright notice supercedes all originally or previously used 
        copyrights being used within the source code.
        
        Author: Lukas Ruf <lr@lpr.ch>
*/

// ************************************************************************** //
// Copyrights (c) 1998 Lukas Ruf                                              //
// ************************************************************************** //

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "TextRead.hpp"

/* ************************************************************************* */
#define rBUFFSIZE 8*1024


TextReadC::TextReadC(char *pfile) {
  cBuffSize = 0;
  cBuffPos  = 0;
  cBuff     = NULL;
  cLine     = NULL;
  printf("Opening (r) %s \n",pfile);
  cFile     = fopen(pfile,"r");
  cEoF      = true;
  if (cFile) {
    cEoF = (fseek(cFile,0,SEEK_END) || (ftell(cFile) <= 0));
    fseek(cFile,0,SEEK_SET);
  }
  return;
}

TextReadC::~TextReadC() {
  if (cFile) fclose(cFile);
  if (cBuff) delete cBuff;
  if (cLine) delete cLine;
  return;
}

bool  TextReadC::EoF() {
  return cEoF;
}

unsigned char TextReadC::GetNextChar() {
  unsigned char xret = 0x00;
  if (cBuff && cBuffPos < cBuffSize) 
    xret = cBuff[cBuffPos++];
  else if (!cBuff) {
    cBuff = new unsigned char[rBUFFSIZE];
    xret = GetNextChar();
  }
  else if (cBuff) {
    cBuffSize = fread((void *)cBuff,1,rBUFFSIZE,cFile);
    cBuffPos  = 0;
    cEoF      = cBuffSize <= 0;
    if (!cEoF) 
      xret = GetNextChar();
  }
  return xret;
}

unsigned char *TextReadC::GetNextLine() {
  unsigned char *xret = NULL;
  if (cLine) {
    int i = 0;
    unsigned char lc = GetNextChar();
    bool  lEoL = !lc || lc == '\n';
    memset(cLine,0,rBUFFSIZE);
    while (i < rBUFFSIZE-1 && !cEoF && !lEoL) {
      cLine[i++] = lc;
      lc = GetNextChar();
      lEoL = !lc || lc == '\n';
    }
    if (!i) {
      delete cLine;
      cLine = NULL;
    }
    xret = cLine;
  }
  else if (!cEoF) {
    cLine = new unsigned char[rBUFFSIZE];
    xret = GetNextLine();
  }
  return xret;
}




