;   corescrn.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                             Lukas Ruf, November 1997
;-------------------------------------------------------------------------------

CRTCPort1   EQU 03D4h   ;Index port for CRTC
CRTCPort2   EQU 03D5h   ;Data port for CRTC
CRTCAddHi   EQU 0Ch     ;Register for lo byte of Video address
CRTCAddLo   EQU 0Dh     ;Register for lo byte of Video address
CRTCCurHi   EQU 0Eh     ;Register for lo byte of Cursor address
CRTCCurLo   EQU 0Fh     ;Register for lo byte of Cursor address
CRTC0C      DB 0        ;CRT Reg 0C HiByte address value
CRTC0D      DB 0        ;CRT Reg 0D LoByte address value

; Offset counter for RM
XYOffs  dw      0


InitVideo       PROC    NEAR
        MOV AL, CRTCAddHi       ;Index of hi byte
        MOV DX, CRTCPort1       ;Index Port
        OUT DX, AL
        MOV AL, CRTC0C          ;hi byte value to send
        MOV DX, CRTCPort2       ;Data Port
        OUT DX, AL
        ;
        MOV AL, CRTCAddLo       ;Index of lo byte
        MOV DX, CRTCPort1       ;Index Port
        OUT DX, AL
        MOV AL, CRTC0D          ;lo byte value to send
        MOV DX, CRTCPort2       ;Data Port
        OUT DX, AL
        RET
InitVideo       ENDP

;////
;// Clear() : Clears the screen
;////
rmClear PROC    NEAR
        PUSH    AX
        PUSH    CX
        PUSH    ES
        PUSH    DI

        MOV     AX,0B800h
        MOV     ES,AX
        XOR     DI,DI
        MOV     AX,1E00h
        MOV     CX,2000
        REP     STOSW

        POP     DI
        POP     ES
        POP     CX
        POP     AX
        RET
rmClear ENDP

;////
;// Call:       rmWrite(char * tosay) : Procedure write directly to video in RM
;//     PUSH    SI(tosay)
;//     CALL    rmWrite
;//             Please NOTE: DS has to be set correctly!!!
;////
rmWrite PROC    NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        PUSH    AX
        PUSH    DI
        PUSH    SI

        MOV     SI,SS:[BP+4]

        MOV     AX,0B800h
        MOV     ES,AX
        MOV     AX,XYOffs
        MOV     DI,AX

        CALL    doWrite
        MOV     AX,DI
        MOV     XYOffs,AX

        POP     SI
        POP     DI
        POP     AX
        POP     ES
        POP     BP
        RET     2
rmWrite ENDP

;////
;// doWrite() : Procedure to Handle Write-Jobs in RM as in PM
;// Init:       ES      : Destination Segment or Selector
;//            (E)DI    : Destination Start Offset
;//             DS      : Source Segment or Selector
;//            (E)SI    : Source Offset of ASCIIZ
;////
doWrite PROC    NEAR
        PUSH    AX

    doWrL:
        LODSB
        OR      AL,AL
        JZ      doWrE

        CMP     AL,0Ah
        JNE     doWr_no_LF
        ;// is LF
        ADD     DI,160  ; complete line length to add
        JMP     doWrL
    doWr_no_LF:
        CMP     AL,0Dh
        JNE     doWr_no_CR
        PUSH    AX
        PUSH    BX
        MOV     AX,DI
        MOV     BX,160
        DIV     BL              ; AX / 160 => AL = AX DIV 160 + AH = AX MOD 160
        MUL     BL              ; AX = AL * BL
        MOV     DI,AX
        POP     BX
        POP     AX
        JMP     doWrL
    doWr_no_CR:
        MOV     AH,1Eh          ; Attribute
        STOSW
      ; STOSB                   ; Write Character
      ; MOV     AL,1Eh          ; Attribute
      ; STOSB                   ; Write Attribute
        CMP     DI,4000         ; Control on Overflow
        JGE     doWrE
        JMP     doWrL
     doWrE:

        POP     AX
        RET
doWrite ENDP

