;   coreload.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch



;Topsy i386                                               Lukas Ruf, August 1997
;-------------------------------------------------------------------------------
;Constant.H - Global constants
        ;////
        ;// Initial Boot Stack
        ;////
        STACKSEG        EQU     1E00h ; (SS) (Stack grows downwards to zero)
        STACKTOP        EQU     1FFFh ; (SP)

        GDTSEG          EQU     0000h ;  Form GDT_BASE in PM
        GDTOFS          EQU     1000h ; 

        CR              EQU     0Dh
        LF              EQU     0Ah


        ;////
        ;//GDT_BASE Address
        ;////
        GDT_BASE        EQU         1000h       ;2nd Page
        GDT_SIZE        EQU     GDTxSIZE        ;created in creategdt.inc

        ;////
        ;//IDT_BASE Address
        ;////
        IDT_SIZE        EQU       0007FFh       ;256x8-1=2047
        IDT_BASE        EQU     00010000h

        PDT_SIZE        EQU       000FFFh
        PDT_BASE        EQU     00011000h

        PET_SIZE        EQU       000FFFh
        PET_BASE        EQU     00012000h

        VID_SIZE        EQU       000FBFh
        VID_BASE        EQU     000B8000h

        OSC_SIZE        EQU       07FFFFh
        OSC_BASE        EQU     00020000h

        cOSKern_Begin   EQU     00000040h      ; GNU Kernel Start Location
        gOSCode_Sel     EQU          1*8
        gOSData_Sel     EQU          2*8

        OSD_SIZE        EQU       07FFFFh
        OSD_BASE        EQU     00020000h

        MEM_SIZE        EQU       0FFFFFh
        MEM_BASE        EQU     00000000h

        ;////
        ;// Bit 0  in CR0 to set Protected Mode
        ;////
        PM_ENABLE       EQU     1

        ;////
        ;// Bit 31 in CR0 to set Page Mode Addressing
        ;////
        PG_ENABLE       EQU     10000000000000000000000000000000b

        ;////
        ;// Ausgabe-Adresse Text (VGA: 0xB8000, Monochrom:0xB0000)
        ;////
        SCR_BASE        EQU     0B8000h

        ;// Load Values
        BOOTSEG           EQU   00000h
        BOOTOFS           EQU   07C00h

        BOOTHead          EQU   00000h
        BOOTTrack         EQU   00000h
        BOOTSector        EQU   00001h


        LOADSEG           EQU   01000h
        LOADOFS           EQU   00000h

        LOADHead          EQU   00000h
        LOADTrack         EQU   00001h
        LOADSector        EQU   00001h


        KERNSEG           EQU   02000h
        KERNOFS           EQU   00000h

        KERNHead          EQU   00000h
        KERNTrack         EQU   00002h
        KERNSector        EQU   00001h


        DRIVSEG           EQU   04000h
        DRIVOFS           EQU   00000h

        DRIVHead          EQU   00000h
        DRIVTrack         EQU   00009h
        DRIVSector        EQU   00001h


        USERSEG           EQU   06000h
        USEROFS           EQU   00000h

        USERHead          EQU   00000h
        USERTrack         EQU   00010h
        USERSector        EQU   00001h

