;   coredisk.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                                Lukas Ruf, August 1997
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
; Disk Access Routines: Low Level, only BIOS INT 13h
;--------------------------------------------------------------------------------


; ResetDisk():
ResetDisk PROC NEAR
        PUSH AX
        PUSH CX
        PUSH DX
        MOV CX,0005h

   ResetTry:
        PUSH CX
        MOV AH,00h
        MOV DL,00h
        INT 13h
        POP CX
        JNC ResetSuccess
        LOOP ResetTry

   ResetSuccess:
        POP DX
        POP CX
        POP AX
        RET
ResetDisk ENDP

; word16b ReadTrackAtOnce(char *buffer, char Head, char Track))
;       Stack:  Segment(buffer)
;               Offset (buffer)
;               Head            (low  Byte = Head)
;               Track           (low  Byte = Track)
;               returnaddr      <- SP
; Return: CF = 1 : Failure

ReadTrackAtOnce PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    ES
        MOV     CX,0005h
 ReadTry:
        PUSH    CX
        MOV     CX,SS:[BP+04]           ; Track (0-based) (CH)
        MOV     CH,CL                   ;       (0-based)
        MOV     CL,1                    ;       (1-based)
        MOV     DX,SS:[BP+06]           ; Head  (0-based) (DH)
        MOV     DH,DL                   ;       (0-based)
        MOV     DL,0                    ; Drive (0-based for floppys)
        MOV     BX,SS:[BP+08]           ; BX of ES:BX
        MOV     AX,SS:[BP+10]           ; ES of ES:BX
        MOV     ES,AX                   ; ES:BX

        MOV     AH,02h                  ; Read
        MOV     AL,18                   ; No. of Sectors

        INT     13h
        POP     CX
        JNC     ReadSuccess
        CALL    ResetDisk
        LOOP    ReadTry
        STC
 ReadSuccess:
        POP     ES
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        POP     BP
        RET     8
ReadTrackAtOnce ENDP

