;   verify.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                            Lukas Ruf, September 1997
;-------------------------------------------------------------------------------
; Procedures for general verification before PM-Switch

Check_Processor PROC NEAR
        PUSHF                   ; save flags for later
        XOR     AH,AH           ; clear high byte
        PUSH    AX              ; push AX on the stack
        POPF                    ; pop this value into the flag register
        PUSHF                   ; push flags on the stack
        POP     AX              ; ...and get flags into AX
        AND     AH,0F0H         ; try to set the high nibble
        CMP     AH,0F0H         ; on a 80386, the high nibble can never be 0f0h
        JE      no386
        MOV     AH,70H          ; now try to set NT and IOPL
        PUSH    AX
        POPF
        PUSHF
        POP     AX
        AND     AH,70H          ; if they couldn't be modified, no 386 is installed
        JZ      no386
        POPF                    ; restore flags
        RET                     ; and return
    no386:
        MOV     SI,OFFSET no386e; if there is no 386, exit with error msg
        PUSH    SI
        CALL    rmWrite
        CALL    Reboot
Check_Processor ENDP

Check_Mode PROC NEAR
        MOV     EAX,CR0         ; get CR0 into EAX
        AND     AL,1            ; check if PM bit is set
        JNZ     not_rm          ; it is set, so exit
        RET                     ; nope, it isn't, Real Mode is good!
    not_rm:
        MOV     SI,OFFSET noreal; exit with msg
        PUSH    SI
        CALL    rmWrite
        CALL    Reboot
Check_Mode ENDP


