;   structur.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                             Lukas Ruf, November 1997
;-------------------------------------------------------------------------------
; Structures: Define Structures used to enter PM

; DESCRIPTOR STRUC
;         LimitLow        dw     0
;         BaseLow         dw     0
;         BaseHighLow     db     0
;         Access          db     0
;         LimitFlag       db     0
;         BaseHigh        db     0
; DESCRIPTOR ENDS


;////
;// Memory Descriptor Codes: All Available (Descriptor Byte 5)
;////
;////        PDLSCEWA
MM_B5_A EQU  00000001b      ; Accesssed
MM_B5_W EQU  00000010b      ; Read/Write
MM_B5_E EQU  00000100b      ; Expand Down (ESP is incremented {fuck Intel})
MM_B5_C EQU  00001000b      ; Code Segment
MM_B5_S EQU  00010000b      ; No System Segment
MM_B5_0 EQU  00000000b      ; Ring 0
MM_B5_1 EQU  00100000b      ; Ring 1
MM_B5_2 EQU  01000000b      ; Ring 2
MM_B5_3 EQU  01100000b      ; Ring 3
MM_B5_P EQU  10000000b      ; Ring 3

;////
;// Memory Descriptor Codes: All Available (Descriptor Byte 6)
;////
;////        GD0A0000
MM_B6_A EQU  00010000b      ; AVL set
MM_B6_D EQU  01000000b      ; Code Seg: Operand Size is 32b, Data Seg: ESP (Big)
MM_B6_G EQU  10000000b      ; Limit in Pages (=0: in Bytes)

MM_NO_  EQU  00000000b      ; nothing
;////
;// System Descriptor Codes: Only Codes for >= 80386 (no compatibility to 80286)
;////
;////            PDLSTYPE
SS_DESC_LDT EQU  00000010b   ; System Descriptor LDT Segment
SS_DESC_TSG EQU  00000101b   ; System Descriptor Task Gate
SS_DESC_TSS EQU  00001001b   ; System Descriptor TSS
SS_DESC_BTS EQU  00001011b   ; System Descriptor Busy TSS
SS_DESC_CLG EQU  00001100b   ; System Descriptor Call Gate
SS_DESC_INT EQU  00001110b   ; System Descriptor Interrupt Gate
SS_DESC_TRP EQU  00001111b   ; System Descriptor Trap      Gate

;////
;// Descriptor for init of GDT Entries:
;////

;////
;// OS Data & Code Descriptor
;////
; MM_OSD_B5 EQU MM_B5_P or MM_B5_0 or MM_B5_S or MM_B5_W
; MM_OSC_B5 EQU MM_B5_P or MM_B5_0 or MM_B5_S or MM_B5_W or MM_B5_C
MM_OSD_B5 EQU 10010011b
MM_OSC_B5 EQU 10011011b

; ALL STACK Segments are implemented as so called "expand-up" stacks
;     STACK GRANULARITY is BYTE
MM_STACK_B5     EQU     10010011b       ; present,DPL=00,Non-System,writeable,accessed
MM_STACK_B6     EQU     01000000b       ; BIG bit

; ALL DATA Segments are implemented in a 32b operand mode
;     DATA GRANULARITY is PAGE
MM_DATA_B5      EQU     10010011b       ; present,DPL=00,Non-System,writeable,accessed
MM_DATA_B6      EQU     11000000b       ; PAGE granularity, BIG bit
MM_DATA_B6_BYTE EQU     01000000b       ; BYTE granularity, BIG bit

; ALL CODE Segments are implemented in a 32b operand mode
;     CODE GRANULARITY is PAGE : non conforming
MM_CODE_B5      EQU     10011011b       ; present,DPL=00,Non-System,code segment,executable/readable,accessed
MM_CODE_B6      EQU     11000000b       ; PAGE granularity, BIG bit

