;   rm_load.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                            Lukas Ruf, September 1997
;-------------------------------------------------------------------------------

;///////////////////////////////////////////////////////////////////////////////
;// Functions for Core Loader                                                 //
;///////////////////////////////////////////////////////////////////////////////
;Concerning ..\DOKU\DISK.DOK
;////
;// Load CoreKernel
;//     Jobs
;//     - Read Tracks (Head/Track): 0/2, 1/2, 0/3, 1/3, 0/4, 1/4 = 55296Bytes
;//       (This is done to be concentrate more on Kernel development...)
;// RM_LOAD(word HEAD, word TRACK, word SEGMENT, word OFFSET)
;////

MARKER          db "TOPSYi386",0
NOT_FOUND       db "No TOPSYi386-marked block found to read.",0

RM_LOAD PROC NEAR
        PUSH    BP
        MOV     BP,SP
        SUB     SP,4

        PUSHA
        PUSH    ES

        XOR     AX,AX
        MOV     SS:[BP-4],AX                 ; Init Counter of Tracks

        MOV     SI,OFFSET R_Loading
        PUSH    SI
        CALL    rmWrite

        MOV     DI,SS:[BP+4]            ; HEAD
        MOV     DX,SS:[BP+6]            ; TRACK
        MOV     AX,SS:[BP+8]            ; SEGMENT
        MOV     BX,SS:[BP+10]           ; OFFSET
    R_Ld_L1:
        MOV     SI,OFFSET(R_crs); Notify progess
        PUSH    SI
        CALL    rmWrite

        PUSH    AX              ; Seg(Buff)
        PUSH    BX              ; Ofs(Buff)
        PUSH    DI              ; Head
        PUSH    DX              ; Track
        CALL    ReadTrackAtOnce
        JC      R_Ld_Error

        CMP     BYTE PTR SS:[BP-4],0   ; on first sector, get no. track to read
        JNE     R_Ld_Sx1

        PUSH    DS
        PUSH    ES
        PUSH    DI
        PUSH    SI
        PUSH    AX

        ; Verify if first block is "TOPSYi386\0"-Header
        ;                           1234567890
        MOV     SI,OFFSET(MARKER)
        MOV     CX,10
        MOV     ES,AX
        XOR     DI,DI
        CLD
        REPE    CMPSB
        JE      R_Ld_Found
        MOV     CX,0
        JMP     R_Ld_Not_Found
    R_Ld_Found:
        MOV     CX,ES:[BX+010h] ; Retrieve No. of Tracks to read
    R_Ld_Not_Found:
        AND     CX,15           ; set Tracks to read: max. 14

        POP     AX
        POP     SI
        POP     DI
        POP     ES
        POP     DS

        JNZ     R_Ld_Sx1       ; if to read -> continue
        MOV     SI,OFFSET(NOT_FOUND)
        PUSH    SI
        CALL    rmWrite
	JMP	R_Ld_Done

    R_Ld_Sx1:
        INC     BYTE PTR SS:[BP-4]

        ADD     BX,18*512       ; Add Track Size to Buff-Offset
        CMP     BX,7*18*512     ; = 64512 -> Attention, Segment boundary
        JB      R_Ld_N_td       ; No yet Segment boundary to be crossed

        ADD     AX,01000h       ; Write new into next segment
        XOR     BX,BX

    R_Ld_N_td:
        INC     DI              ; Head Change
        CMP     DI,2
        JB      R_Ld_N_Inc
        XOR     DI,DI           ; Head Change
        INC     DX              ; Track increment
    R_Ld_N_Inc:
        MOV     SI,OFFSET(R_dot); Notify progess
        PUSH    SI
        CALL    rmWrite

        LOOP    R_Ld_L1
        JMP     R_Ld_Done
    R_Ld_Error:
        MOV     SI,OFFSET R_LoadError
        PUSH    SI
        CALL    rmWrite
        CALL    Reboot

    R_Ld_Done:
        MOV     SI,OFFSET(R_Loaded)
        PUSH    SI
        CALL    rmWrite

        ; // Concatenation of Segments is Done in PM

        POP     ES
        POPA

        MOV     SP,BP
        POP     BP
        RET     8
RM_LOAD ENDP


