;   pm_swtch.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                            Lukas Ruf, September 1997
;-------------------------------------------------------------------------------
; Switch to Protected Mode

PM_Switch       PROC    NEAR
        ;////////////////////////////////
        ;/ Kernel is at right place    //
        ;/ - Switch to PM              //
        ;/ - Jump into Kernel          //
        ;////////////////////////////////

        LIDT    FWORD PTR IDTptr        ; Interrupt Descriptor Table
        LGDT    FWORD PTR GDTptr        ; Global Descriptor Table

        MOV     EAX,CR0                 ;
        OR      EAX,1                   ; Switch to Protected Mode
        MOV     CR0,EAX                 ;
        JMP     NowInPM                 ; Clear Prefetch Queue
        NOP
        NOP
NowInPM:
        MOV     BX,gOSData_Sel              ; Setup Data Selectors
        MOV     DS,BX                       ; D Selector
        MOV     ES,BX                       ; E Selector
        MOV     FS,BX                       ; F Selector
        MOV     GS,BX                       ; G Selector
        MOV     SS,BX                       ; S Selector

        MOV     EAX,OSD_SIZE                ; Setup Stack Size
        MOV     ESP,EAX

        ;/////////
        ;// PROTECTED MODE FAR JUMP TO (OSCodeSelector:OSKernBegin) = C-Kernel-Start
        ;/////////
        DB 066h                 ; 32 bit Data prefix
        DB 067h                 ; 32 bit Address instruction prefix
        DB 0EAh                 ; far jump opcode
        DD cOSKern_Begin        ; 32 bit Offset   ( Code Offset )
        DW gOSCode_Sel          ; 16 bit Selector ( Code Selector )

        RET                     ; This should never be executed,
PM_Switch  ENDP


